<?php
 
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
 class webdWoocommerceReportingStatisticsAdmin{

	public $allowed_html = array(
            'a' => array(
                'style' => array(),
                'href' => array(),
                'title' => array(),
                'class' => array(),
                'id'=>array(),
				'target'=>array(),
            ),
			'i' => array('style' => array(),'class' => array(),'id'=>array() ),
            'br' => array('style' => array(),'class' => array(),'id'=>array() ),
            'em' => array('style' => array(),'class' => array(),'id'=>array() ),
            'strong' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h1' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h2' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h3' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h4' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h5' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h6' => array('style' => array(),'class' => array(),'id'=>array() ),
            'img' => array('style' => array(),'class' => array(),'id'=>array() ),
            'p' => array('style' => array(),'class' => array(),'id'=>array() ),
            'div' => array('style' => array(),'class' => array(),'id'=>array() ),
            'section' => array('style' => array(),'class' => array(),'id'=>array() ), 
            'ul' => array('style' => array(),'class' => array(),'id'=>array() ),
            'li' => array('style' => array(),'class' => array(),'id'=>array() ),
            'ol' => array('style' => array(),'class' => array(),'id'=>array() ),
            'video' => array('style' => array(),'class' => array(),'id'=>array() ),
            'blockquote' => array('style' => array(),'class' => array(),'id'=>array() ),
            'figure' => array('style' => array(),'class' => array(),'id'=>array() ),
            'figcaption' => array('style' => array(),'class' => array(),'id'=>array() ),
            'style' => array(),
            'button' => array(
                'class' => array(),            
            ),

            'input' => array(
                'type' => array(), 
				'class' => array(), 				
				'placeholder' => array(), 
				'disabled' => array(),		
            ),				
            'option' => array(
                'value' => array(),
                'stock' => array(),
                'quantity' => array(),
                'price' => array(),
                'id' => array(),              
            ),			
            'iframe' => array(
                'height' => array(),
                'src' => array(),
                'width' => array(),
                'allowfullscreen' => array(),
                'style' => array(),
                'class' => array(),
                'id'=>array()                
            ),             
            'img' => array(
                'alt' => array(),
                'src' => array(),
                'title' => array(),
                'style' => array(),
                'class' => array(),
				'width' => array(),
				'height' => array(),
                'id'=>array()
            ), 
            'video' => array(
                'width' => array(),
                'height' => array(),
                'controls'=>array(),
                'class' => array(),
                'id'=>array()
            ),  
            'source' => array(
                'src' => array(),
                'type' => array(),
                'class' => array(),
                'id'=>array()
            ),             
        );

    private $orders = [];
    private $theproducts = [];
	private $orderMonths = [];
	private $orderYears = [];
    private $chunkSize = 1000;
	private $countries = [];
	private $cities = [];
	private $payments = [];
	
	private $total =0;
	private $subtotal =0;
	private $shipping =0;
	private $taxes =0;
	private $refunds =0;
	private $discounts =0;
	private $products;
	private $net;
	private $saleEvery;
	private $datediff;
	private $uniqueDates = [];
	private $avg;
	
	public function proModal(){ ?>
		<div id="webdWoocommerceReportingStatisticsModal">
		  <!-- Modal content -->
		  <div class="modal-content">
			<div class='clearfix'><span class="close">&times;</span></div>
			<div class='clearfix verticalAlign'>
				<div class='columns2'>
					<center>
						<img style='width:90%' src='<?php echo plugins_url( 'images/'.$this->slug.'-pro.png', __FILE__ ); ?>' style='width:100%' />
					</center>
				</div>
				
				<div class='columns2'>
					<h3><?php  esc_html_e('Go PRO and get more important features!',"webd-woocommerce-reporting-statistics");?></h3>
					
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by Product',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by Product Category',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by City, Country, Payment Method',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Next Months Forecast per Product / Category',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Custom Report Builder including custom fields',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Custom Set From - To date to Search',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by selecting Month or Year',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Export reports in Excel',"webd-woocommerce-reporting-statistics");?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Current Selling Products Low Stock Products Reminder!',"webd-woocommerce-reporting-statistics");?> </p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Low Stock Products Report',"webd-woocommerce-reporting-statistics");?> </p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Email Report',"webd-woocommerce-reporting-statistics");?></p>
					<p class='bottomToUp'><center><a target='_blank' class='proUrl' href='<?php print $this->proUrl; ?>'><?php  esc_html_e('GET IT HERE',"webd-woocommerce-reporting-statistics");?></a></center></p>
				</div>
			</div>
		  </div>
		</div>		
		<?php
	}
	
	public function adminHeader(){
		?>
		<img src='<?php echo plugins_url( 'images/'.$this->slug.'.png', __FILE__ ); ?>' style='width:100%' />	
		<?php	
	}
	
	
	public function adminSettings(){
		        global $product;
				
				$this->tab = array( 'all' => esc_html__('GENERAL',"webd-woocommerce-reporting-statistics"),'years' => esc_html__('PER YEAR',"webd-woocommerce-reporting-statistics"),'months' => esc_html__('PER MONTH',"webd-woocommerce-reporting-statistics"),'top' => esc_html__('TOP 5 PRODUCTS',"webd-woocommerce-reporting-statistics"));
				if(isset($_GET['tab']) || (isset($_GET['tab']) && $_GET['tab']=='all' ) ){
					$this->activeTab = $_GET['tab'] ;
				}else $this->activeTab = 'all';
				echo '<h3 class="nav-tab-wrapper" >';
				foreach( $this->tab as $tab => $name ){
					$class = ( $tab == $this->activeTab ) ? ' nav-tab-active' : '';
					echo "<a class='nav-tab".$class." contant' href='?page=".$this->slug."&tab=".$tab."'>".$name."</a>";
				}
				?>
				<a class='nav-tab  proVersion' href="#" style='background:#42b72a;color:#fff' ><?php  esc_html_e('GO PRO',"webd-woocommerce-reporting-statistics");?></a>
				<a class='nav-tab  extendwp_extensions' href="#" style='background:#9B2E91;color:#fff' ><i class='fa fa-plug'></i> <?php  esc_html_e('More extensions',"webd-woocommerce-reporting-statistics");?></a>
				<?php
				echo "</h3>";
				
				?>
					
				<?php
				$selected = '';

				if( !file_exists( plugin_dir_path( __FILE__ ).'orders.txt' )  && !file_exists( plugin_dir_path( __FILE__ ).'products.txt' ) ){
					delete_option('fetchOrders_for_stats' );
					?>
					<div class="notice notice-success is-dismissible">
						<p style='vertical-align:middle'>
							
							<?php esc_html_e( 'Please reload the page to start getting orders...If not getting orders, please check WP CRON events for fetchOrders_for_stats action and run it.' , "webd-woocommerce-reporting-statistics" ); ?>
						</p>
					</div>
					<?php						
				}
		
				if( ( isset( $_GET['tab'] ) && $_GET['tab'] =='all' ) || !isset( $_GET['tab'] ) ){
					
					$selected = date('Y-m-d', strtotime("first day of this month"));
					
					print "<div class='report_widge'>";
							$this->parse_file();
							$this->select_dropdown();								
							$this->filter_orders( $selected );																			
							$this->all_sales();
							
					print "</div>";
							
				}elseif( isset($_GET['tab']) && ( $_GET['tab'] =='years' || $_GET['tab'] =='months' ) ){
					
					print "<div class='report_widgt'>";
					
						$this->parse_file();
						$this->select_dropdown();
						$this->filter_orders( $selected );					
						$this->getOrdersBy( 'month');
						
					print "</div>";
					
				}elseif( isset($_GET['tab']) && ( $_GET['tab'] =='years') ){
					
					print "<div class='report_widgt'>";
					
						$this->parse_file();
						$this->select_dropdown();
						$this->filter_orders( $selected );					
						$this->getOrdersBy( 'year');
						
					print "</div>";			
				
				}elseif(isset($_GET['tab']) && $_GET['tab'] =='stock'){?>
				<div class='premium_msg'>
				<p>
					<strong>
					<?php  esc_html_e('Only available on PRO Version',"webd-woocommerce-reporting-statistics");?> <a class='premium_button' target='_blank'  href='<?php print $this->proUrl;?>'><?php  esc_html_e('Get it Here',"webd-woocommerce-reporting-statistics");?></a>
					</strong>
				</p>
				</div>			
				<div class='report_widgt'>
								
					<div id="tabs3" class='clearfix'>
						<ul>
							<li><a href="#selling"><?php  esc_html_e( 'Selling Products Low Stock Reminder',"webd-woocommerce-reporting-statistics" );?></a></li>
							<li><a href="#noselling"><?php  esc_html_e( 'All Time Low Stock Products',"webd-woocommerce-reporting-statistics" );?></a></li>																		
						</ul>
						<?php $this->sellingProdStock(); ?>
						<?php $this->LowStock(); ?>
					</div>												
				</div>				
				<?php }elseif( isset( $_GET['tab'] ) && $_GET['tab'] =='top' ){ ?>
						<div class='report_widge'>
							<?php  $this->topSellers(); ?> 
						</div>				
				<?php }elseif(isset( $_GET['tab'] ) && $_GET['tab'] =='email' ){ ?>
				<div class='premium_msg'>
				<p>
					<strong>
					<?php  esc_html_e('Only available on PRO Version',"webd-woocommerce-reporting-statistics");?> <a class='premium_button' target='_blank'  href='<?php print $this->proUrl;?>'><?php  esc_html_e('Get it Here',"webd-woocommerce-reporting-statistics");?></a>
					</strong>
				</p>
				</div>				
					<form method="post" id='<?php print "webd-woocommerce-reporting-statistics"; ?>Form'  
					action= "<?php echo admin_url( "admin.php?page=".$this->slug."&tab=email" ); ?>">
					<?php
						settings_fields( "webd-woocommerce-reporting-statistics"."general-options" );
						do_settings_sections( "webd-woocommerce-reporting-statistics"."general-options" );				
						
					?></form>
	
				<?php } 
	}
	
	public function adminFooter(){ ?>
		<div class='clearfix'>
		<hr>
		<div></div>
		<?php $this->rating(); ?>
		<a target='_blank' class='web_logo' href='https://extend-wp.com/wordpress-premium-plugins/'>
			<img  src='<?php echo plugins_url( 'images/extendwp.png', __FILE__ ); ?>' alt='Get more plugins by extend-wp.com' title='Get more plugins by extend-wp.com' />
		</a><div class='get_ajax'></div>
		</div>
		<?php 
	}

	public function rating(){
	?>
		<div class="notices notice-success rating is-dismissible">

			<?php esc_html_e( "You like this plugin? ", 'smw' ); ?><i class='fa fa-smile-o' ></i> <?php esc_html_e( "Then please give us ", "webd-woocommerce-reporting-statistics" ); ?>
				<a target='_blank' href='https://wordpress.org/support/plugin/webd-woocommerce-advanced-reporting-statistics/reviews/#new-post'>
					<i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i>
				</a>

		</div> 	
	<?php	
	}
	
	public function sendReport(){
		?>
		<select class='proVersion' >
			<option   readonly value=''><?php  esc_html_e('Select...',"webd-woocommerce-reporting-statistics");?></option>
			<option value='yes'><?php  esc_html_e('yes',"webd-woocommerce-reporting-statistics");?></option>
			<option value='no'><?php  esc_html_e('no',"webd-woocommerce-reporting-statistics");?></option>
		</select>
		<?php
	}
	
	public function emailForReport(){
		?>
		<input type="text" readonly placeholder='Email to send - PRO Version' class='proVersion' />
		<?php
	}
	
	public function emailFrequency(){
		?>			
		<select  readonly class='proVersion' >
			<option   value=''><?php  esc_html_e('Select...',"webd-woocommerce-reporting-statistics");?></option>
			<option value='daily'><?php  esc_html_e('Daily',"webd-woocommerce-reporting-statistics");?></option>
			<option value='weekly'><?php  esc_html_e('Weekly',"webd-woocommerce-reporting-statistics");?></option>
			<option value='monthly'><?php  esc_html_e('Monthly',"webd-woocommerce-reporting-statistics");?></option>
		</select>			
		<?php
	}
	
	public function settingsSection(){
		add_settings_section("webd-woocommerce-reporting-statistics"."general", "", null, "webd-woocommerce-reporting-statistics"."general-options");
		add_settings_field('sendReport',"Send Report", array($this, 'sendReport'),  "webd-woocommerce-reporting-statistics"."general-options", "webd-woocommerce-reporting-statistics"."general");
		add_settings_field('emailFrequency',"Email Frequency", array($this, 'emailFrequency'),  "webd-woocommerce-reporting-statistics"."general-options", "webd-woocommerce-reporting-statistics"."general");
		add_settings_field('emailForReport',"Emai for Report", array($this, 'emailForReport'),  "webd-woocommerce-reporting-statistics"."general-options", "webd-woocommerce-reporting-statistics"."general");			
	}

	
	public function update_orders( $order ) {
		
		if( file_exists( plugin_dir_path( __FILE__ ).'orders.txt' ) ){
			$filename = plugin_dir_path( __FILE__ ) . 'orders.txt';
			wp_delete_file( $filename );	
			delete_option('fetchOrders_for_stats' );
		}
		if( file_exists( plugin_dir_path( __FILE__ ).'products.txt' ) ){
			$filename = plugin_dir_path( __FILE__ ) . 'products.txt';
			wp_delete_file( $filename );	
		}		
		delete_option( 'fetchOrders_for_stats' );

	  
	}
	
	public function pending_orders_notice(){

		$screen = get_current_screen();
		if ( 'woocommerce_page_webd-woocommerce-reporting-statistics'  !== $screen->base )				
		return;
			
		if( get_option( 'fetchOrders_for_stats' ) !== 'finished' ){
			
			
			?>
			<div class="notice notice-success is-dismissible">
				<p style='vertical-align:middle'>
				    <img style='width:25px' src='<?php echo plugins_url( 'images/loading1.gif', __FILE__ ); ?>' alt='loading' title='loading' />
				    <?php esc_html_e( 'Please wait until orders are retrieved.. refresh the page to recheck.' , "webd-woocommerce-reporting-statistics" ); ?>
				</p>
			</div>
			<?php			
		}
	}
	

	public function fetchOrders_for_stats() {
		
		//error_log( 'function should start now' );
		
		if( !get_option( 'fetchOrders_for_stats' ) ){
			$offset = 0;
		}else $offset = get_option( 'fetchOrders_for_stats' );
		$offset = get_option( 'fetchOrders_for_stats' , 0 );	

		$ordersChunk = $this->get_orders( $offset, $this->chunkSize );
		
		$logfile = plugin_dir_path( __FILE__ ) . '/orders.txt';
		$file = fopen( $logfile, "a" ); 

		$productsfile = plugin_dir_path( __FILE__ ) . '/products.txt';
		$prods = fopen( $productsfile, "a" ); 
		
		$order_data = []; // Initializing
		$products_data = []; // Initializing
		
			$handle = fopen( $logfile, 'r');
			$check = fgets($handle);
	
		foreach ($ordersChunk as $order) {
			

			 //if( strpos( $check ,$order->get_id() ) === false  ) {
				 			 

				$order_data['order_id']       = $order->get_id();
				$order_data['transaction_id'] = ( method_exists( $order, 'get_transaction_id' ) ) ? $order->get_transaction_id(): '';				
				$order_data['date'] = ( method_exists( $order, 'get_date_created' ) ) ? date("Y-m-d",strtotime($order->get_date_created() ) ): '';
				$order_data['month'] = ( method_exists( $order, 'get_date_created' ) ) ? date("Y-m",strtotime($order->get_date_created() ) ): '';
				$order_data['year'] = ( method_exists( $order, 'get_date_created' ) ) ? date("Y",strtotime($order->get_date_created() ) ): '';
				$order_data['user_id'] = ( method_exists( $order, 'get_user_id' ) ) ? $order->get_user_id() : '';
				$order_data['name'] = ( method_exists( $order, 'get_billing_first_name' ) && method_exists( $order, 'get_billing_last_name' ) ) ? $order->get_billing_first_name() . " " . $order->get_billing_last_name() : '';
				$order_data['status'] = ( method_exists( $order, 'get_status' ) ) ? $order->get_status() : '';
				$order_data['order_payment_method'] = ( method_exists( $order, 'get_payment_method_title' ) ) ? $order->get_payment_method_title() : '';
				$order_data['city'] = ( method_exists( $order, 'get_billing_city' ) ) ? $order->get_billing_city() : '';
				$order_data['state'] = ( method_exists( $order, 'get_billing_state' ) ) ? $order->get_billing_state() : '';
				$order_data['mail'] = ( method_exists( $order, 'get_billing_email' ) ) ? $order->get_billing_email() : '';
				$order_data['company'] = ( method_exists( $order, 'get_billing_company' ) ) ? $order->get_billing_company() : '';
				$order_data['phone'] = ( method_exists( $order, 'get_billing_phone' ) ) ? $order->get_billing_phone() : '';
				$order_data['country'] = ( method_exists( $order, 'get_billing_country' ) ) ? $order->get_billing_country() : '';
				$order_data['shipping'] = ( method_exists( $order, 'get_shipping_total' ) ) ? $order->get_shipping_total() : '';
				$order_data['subtotal'] = ( method_exists( $order, 'get_subtotal' ) ) ? $order->get_subtotal() : '';
				$order_data['total'] = ( method_exists( $order, 'get_total' ) ) ? $order->get_total() : '';
				$order_data['tax'] = ( method_exists( $order, 'get_total_tax' ) ) ? $order->get_total_tax() : '';
				$order_data['refund'] = ( method_exists( $order, 'get_total_refunded' ) ) ? $order->get_total_refunded() : '';
				$order_data['discount'] = ( method_exists( $order, 'get_total_discount' ) ) ? $order->get_total_discount() : '';
				// Get and Loop Over Order Items
				$productids = array();
				$quantity = array();
				$products = array();
				
				foreach ( $order->get_items() as $item_id => $item ) {
					$product_name = $item->get_name();
					$product_id = ( !empty( $item->get_variation_id() ) ) ? $item->get_variation_id() : $item->get_product_id();
					//$product_id = post_exists( $item->get_name() );
					 $id = $product_id;
					 array_push( $productids , $product_id );
					 array_push( $quantity , $item->get_quantity() );
					 
					 //$products[] = array( 'id'=>$product_id,'quantity'=>$item->get_quantity(),'total'=>$item->get_subtotal() );
					 
					 $products_data['order_id']       = $order->get_id();
					 $products_data['product_id'] =$item->get_product_id();
					 $products_data['id'] = ( !empty( $item->get_variation_id() ) ) ? $item->get_variation_id() : $item->get_product_id();
					 $products_data['quantity'] = ( method_exists( $item, 'get_quantity' ) ) ? $item->get_quantity() : '';
					 $products_data['total'] = ( method_exists( $item, 'get_subtotal' ) ) ? $item->get_subtotal() : '';
					 
    				$json_products_data = json_encode($products_data);	
    				fwrite($prods, $json_products_data ); // Write the order to the file.
				}
				
				$order_data['quantity'] = array_sum( $quantity );
				$order_data['products'] = implode( ",", $productids );
				//$order_data['productss'] = $products;

				$json_order_data = json_encode($order_data);		
				fwrite($file, $json_order_data ); // Write the order to the file.
				
				
				
		//	}
			
		}

		
		fclose($file); // Close the file.
        fclose($prods); // Close the file.
			
		if ( count( $ordersChunk ) == $this->chunkSize ) {
			
			//error_log( 'fetchOrders_for_stats ' .  count( $ordersChunk ) . " " . $this->chunkSize  ); 
			update_option('fetchOrders_for_stats', $offset + $this->chunkSize );
			
            //delete_transient( 'doing_cron' );
			wp_clear_scheduled_hook( 'fetchOrders_for_stats' );
			wp_schedule_single_event( time(), 'fetchOrders_for_stats' );
			
            //spawn_cron();
            //sleep( 1 );	
		} else {
			// If we got less than a full chunk, we're done; reset the offset
			//error_log(  " Should finish here: ". $ordersChunk  . " " . $this->chunkSize  ); 
			
			remove_action( 'fetchOrders_for_stats', array( $this, 'fetchOrders_for_stats' ) );
			wp_clear_scheduled_hook( 'fetchOrders_for_stats' );
			update_option( 'fetchOrders_for_stats', 'finished' );
		}
	}
	
    public function parse_file( ) {


		if( file_exists( plugin_dir_path( __FILE__ ).'orders.txt' ) ){
			$logfile = plugin_dir_path( __FILE__ ) . '/orders.txt'; 
			$orders = file($logfile, FILE_IGNORE_NEW_LINES);
			$orders = file_get_contents( $logfile );
			$orders = substr( $orders, 1, -1); //important for the next step , removing first { and last }
			// Split the data into individual order strings
			$order_strings = explode('}{', $orders);
			
			// Parse each JSON object and store in an array
			$orders = [];
			foreach ($order_strings as $order_str) {
				// Add back the curly braces to make valid JSON
				$order_str = '{' . $order_str . '}';
				$order = json_decode($order_str, true);
				if ($order !== null) {
					$orders[] = $order;
				}
				
			}
			$this->orders = $orders;
			
			foreach ( $this->orders as $order ) {
		
				if ( !in_array( $order['month'] , $this->orderMonths ) ) array_push( $this->orderMonths, $order['month'] );					
				if ( !in_array( $order['year'] , $this->orderYears ) ) array_push( $this->orderYears, $order['year'] );	
				if ( !in_array( $order['date'] , $this->uniqueDates ) ) array_push( $this->uniqueDates, $order['date'] );
				
				$this->total += (float)$order['total'];
				$this->subtotal += (float)$order['subtotal'];
				$this->shipping += (float)$order['shipping'];
				$this->taxes += (float)$order['tax'];
				$this->refunds += (float)$order['refund'];
				$this->discounts += (float)$order['discount'];
				$this->products += (float)$order['quantity'];
				
			}
			
		}	
		if( file_exists( plugin_dir_path( __FILE__ ).'products.txt' ) ){
			$logfile = plugin_dir_path( __FILE__ ) . '/products.txt'; 
			$products = file($logfile, FILE_IGNORE_NEW_LINES);
			$products = file_get_contents( $logfile );	
			// Split the data into individual order strings
			$products_strings = explode('}{', $products);
			
			// Parse each JSON object and store in an array
			$products = [];
			foreach ($products_strings as $product_str) {
				// Add back the curly braces to make valid JSON
				$product_str = '{' . $product_str . '}';
				$product = json_decode($product_str, true);
				if ($product !== null) {
					$products[] = $product;
				}
				
			}
			$this->theproducts = $products;
			
		}		

    }
	
    private function get_orders($offset, $limit) {
		
		global $woocommerce;
		
        $args = array(
            'limit' => sanitize_text_field( $limit ),
            'offset' => sanitize_text_field( $offset ),
			'orderby' => 'date', //has no effect as its a meta field 
			'order' => 'DESC',			
        );
		
        return wc_get_orders($args);
    }

    public function filter_orders( $default ) {
		
        if (isset($_POST['filter_orders']) || !empty( $default ) ) {
						
			$selected = (empty($_POST['selected'])) ? $default : $_POST['selected'];
			$order_status = (empty($_POST['order_status'])) ? '' : $_POST['order_status'];
			$customer = (empty($_POST['customer'])) ? '' : $_POST['customer'];

            $filters = [
                'selected' => sanitize_text_field( $selected ),
                'order_status' => sanitize_text_field( $order_status ),
				'customer' => sanitize_text_field( $customer ),

            ];

            $filteredOrders = [];
            $filteredProducts = [];
			
			$this->total = 0; 
			$this->subtotal = 0; 
			$this->taxes = 0; 
			$this->refunds = 0; 
			$this->shipping = 0; 
			$this->refunds = 0; 
			$this->discounts = 0; 
			$this->products = 0; 
			$this->uniqueDates = []; 
			
            foreach ( $this->orders as $order ) {
				
                if ( $this->order_matches_filters( $order, $filters ) ) {
                    $filteredOrders[] = $order;
					
					$this->total += (float)$order['total'];
					$this->subtotal += (float)$order['subtotal'];
					$this->taxes += (float)$order['tax'];
					$this->refunds += (float)$order['refund'];
					$this->discounts += (float)$order['discount'];
					$this->shipping += (float)$order['shipping'];
					$this->products += (float)$order['quantity'];
					if ( !in_array( $order['date'] , $this->uniqueDates ) ) array_push( $this->uniqueDates, $order['date'] );
                }
            }
            
             $this->orders = $filteredOrders;
             
            foreach ( $this->theproducts as $product ) {


                if ( array_search( $product['order_id'], array_column( $this->orders, 'order_id')) !== false ) {
                    $filteredProducts[] = $product;
                }
            }
            
           
            $this->theproducts = $filteredProducts;
        }
    }

    private function order_matches_filters( $order, $filters ) {


       
        if ($filters['selected'] && $order['date'] < $filters['selected'] ) {
            return false;
        }

        if ($filters['customer'] && $order['user_id'] != $filters['customer']) {
            return false;
        }
		
        if ($filters['order_status'] && $order['status'] != $filters['order_status']) {
            return false;
        }
 

		
        return true;
    }
	
	public function getOrdersBy( $period ){
				
		if( count( $this->orders ) !=0 ){
			
        $ordersBy = [];
				
        foreach ( $this->orders as $order ) {
            $by = $order[ $period ];
            $ordersBy[$by][] = $order;
        }
		echo '<div class="columns2">';
		
			if(isset($_POST['order_status']) && !empty($_POST['order_status'])){
				print "<h3>". esc_html__('Analysis for Orders with Status: ',"webd-woocommerce-reporting-statistics").esc_attr($_POST['order_status'] )." </h3>";
			}			
		
			echo "<table class='widefat striped' >";
				echo "<thead><th>" . esc_html( ucfirst( $period ) ) . "</th><th>" . esc_html__( "# Orders" , "webd-woocommerce-reporting-statistics" ) . "</th><th>" . esc_html__( "Total Amount" , "webd-woocommerce-reporting-statistics" ) . "</th><th>" . esc_html__( " % in Total" , "webd-woocommerce-reporting-statistics" ) . "</th></thead>";
				echo "<tbody>";
				
				$totals = array();
				foreach ( $ordersBy as $by => $orders ) {
					$totalAmount = $this->calculate_total_amount( $orders );
					$percent = (  (float)$totalAmount / $this->total )*100;
					$percent = round( $percent, 2 ) ." %";	
					
					array_push( $totals, $totalAmount );
					$reportPeriod[] = array("year"=>$by,"total"=>$totalAmount );
					
					echo "<tr><td>$by</td><td>" . count( $orders ) . "</td><td>" . wc_price( $totalAmount ) . "</td><td>$percent</td></tr>";
				}
				echo "<thead class='totals'><th>" . esc_html__( "Totals" , "webd-woocommerce-reporting-statistics" ) . "</th><th>" . count( $this->orders ) . "</th><th>" . wc_price( $this->total ) . "</th><th>100%</th></thead>";
				echo "</tbody>";
			echo '</table>';
			
			if( !isset( $_POST['order_status']) && isset( $_GET['tab'] ) &&  $_GET['tab'] =='months' ) {

				if( array_sum ($totals ) != '' ){					
					$forecast = $this->forecastHoltWinters(array_reverse($totals))[0];
				}else $forecast='';

				$num = count( $ordersBy ); 
				$average = $this->total / $num;	
	
				print "<div class='report_widget columns2 em'><b><i class='fa fa-2x fa-filter'></i> ". esc_html__( 'AVERAGE SALES', "webd-woocommerce-reporting-statistics") . " <span>" . wc_price( $average ) . "</span></b></div>";
				print "<div class='report_widget columns2 em'><b><i class='fa fa-2x fa-signal'></i> ". esc_html__( 'NEXT MONTH SALES FORECAST', "webd-woocommerce-reporting-statistics") . " <span>" .  wc_price( $forecast ) . "</span></b></div>";	

			} 			
			
		echo '</div>'; 
		
		?>
		<div  class="chart-container columns2" style="position: relative" >
			<canvas id="byPeriod"></canvas>
		</div>
				
		<script>
				var ctx = document.getElementById("byPeriod");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach( array_reverse( $reportPeriod ) as $order ){print '"' .$order['year'] . '",';};?>],
						datasets: [{
							label: 'Sales',
							data: [<?php foreach( array_reverse( $reportPeriod )  as $order ){print '"' .$order['total'] . '",';};?>],			
							backgroundColor: [
								<?php foreach( array_reverse( $reportPeriod ) as $order ){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [
								<?php foreach( array_reverse( $reportPeriod ) as $order ){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},					
					options: {
						title: {
							display: true,
							text: 'SALES/YEAR'
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
		</script>		
				 
				 
        <?php 		
		}else print esc_html__( "There are no orders...", "webd-woocommerce-reporting-statistics" );
	}



	public function select_dropdown() {
		
		?>

		<div class='reportCalendar'>
		
		<?php $this->selectProduct() ; ?>
		
		<form method='post'  id='selectDates' autocomplete="off" role="presentation" >	

				<select name='customer' class='dateFilter'>
					<option value=''><?php esc_html_e( 'Customer..',"webd-woocommerce-reporting-statistics" );?></option>
				<?php

				// get customer
				$customer_query = new WP_User_Query(
					array(
						'role'	  =>	'customer',
					)
				);
				$custs = $customer_query->get_results();

						foreach($custs as $res){
							$user_info = get_userdata( $res->ID );
							echo "<option  value='".esc_attr( $res->ID )."'>" . esc_attr( $user_info->first_name . " " . $user_info->last_name ) . "</option>";			
						}		
				?>
				</select> 

				<select class='dateFilter proVersionPreselect' style='background:#eee;' id="pt-filter-by-date">
					<option value=""><?php  esc_html_e('Query by...',"webd-woocommerce-reporting-statistics");?></option>
					<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Product - in PRO',"webd-woocommerce-reporting-statistics");?></option>
					<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Category - in PRO',"webd-woocommerce-reporting-statistics");?></option>
					<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('City - in PRO',"webd-woocommerce-reporting-statistics");?></option>
					<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Country - in PRO',"webd-woocommerce-reporting-statistics");?></option>
					<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Payment Method - in PRO',"webd-woocommerce-reporting-statistics");?></option>

				</select>
				
				<select name='order_status' id='order_status' class='dateFilter'>
					<option value=''><?php esc_html_e('Order Status', "webd-woocommerce-reporting-statistics" );?></option>
									
						<?php 
							foreach( wc_get_order_statuses() as $key=>$value){
								print "<option value='".esc_attr($key)."' >".esc_attr($value)."</option>";
							}									
						?>

				</select>
			
			<?php if( empty( $_REQUEST['tab'] ) || ( isset( $_REQUEST['tab'] ) &&  $_REQUEST['tab'] ==='all' ) ){ ?>
			    <?php $date = current_time( 'mysql' ) ; 
			    $today = date("Y-m-d", strtotime( $date ) ); 
			    ?>
				
				<select name="selected" class='dateFilter '>
					<option value=""><?php  esc_html_e('Preselected Period',"webd-woocommerce-reporting-statistics");?></option>
					<option value="<?php print esc_attr( $today ); ?>"><?php  esc_html_e( 'Today',"webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( $date . "- 1 day" ) ); ?>"><?php  esc_html_e( 'Yesterday',"webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( $date . "- 7 days" ) ); ?>"><?php  esc_html_e( 'This Week',"webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( "first day of this month" ) ); ?>"><?php  esc_html_e( 'This Month',"webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( $date . "- 2 months" ) ); ?>"><?php  esc_html_e( 'Last 2 Months',"webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( $date . "- 3 months" ) ); ?>"><?php  esc_html_e( 'Last 3 Months', "webd-woocommerce-reporting-statistics" );?></option>
					<option value="<?php print date( 'Y-m-d', strtotime( $date . "- 6 months" ) ); ?>"><?php  esc_html_e( 'Last 6 Months', "webd-woocommerce-reporting-statistics" );?></option>
				</select>	


				
				<select name='month' class='dateFilter proVersionPreselect' style='background:#eee;' id="pt-filter-by-date">
					
					<option value=''><?php esc_html_e( 'Select Month..',"webd-woocommerce-reporting-statistics" );?></option>
					<?php foreach( $this->orderMonths as  $month ){ 
						?>
						
						<option value='proVersionPreselected' ><?php print esc_attr( $month ); ?></option>
						
					<?php } ?>
				</select> 
				<select name='year' class='dateFilter proVersionPreselect' style='background:#eee;' id="pt-filter-by-date" >
					
					<option value=''><?php esc_html_e( 'Select Year..',"webd-woocommerce-reporting-statistics" );?></option>
					<?php foreach( $this->orderYears as  $year ){ 
						?>
						
						<option value='proVersionPreselected'  ><?php print esc_attr( $year ); ?></option>
						
					<?php } ?>
				</select>
		
			
				
				 <input  placeholder='From'  class="from datepicker dateFilter" readonly name='from' value='' />
				 <input  placeholder='To'  class="to datepicker dateFilter"  readonly name='to' value='' />
			 
			 <?php } ?>	
			 
			 <?php wp_nonce_field("webd-woocommerce-reporting-statistics"); ?>
			 <input type='submit' class='button button-primary' />
		 </form>
		 
		 </div>
	<?php 

	}
	
	public function selectProduct(){
		?>
		<form method='post'  style='display:inline' id='selectProduct' autocomplete="off" role="presentation" >
		<p><span class='button button-primary prodToggler proVersion'><?php  esc_html_e('Select a Product..',"webd-woocommerce-reporting-statistics");?></span></p>		
		</form>
		<?php
	}

    private function calculate_total_amount($orders) {
		
        $totalAmount = 0;

        foreach ($orders as $order) {
            $totalAmount += (float)$order['total'] - (float)$order['refund'];
        }

        return $totalAmount;
    }
	
	public function overview(){

		?>
		
			<center>
			<?php 
			
			$date = current_time( 'mysql' ) ; 
			$today = date('Y-m-d', strtotime( $date ) );
			$todayDisplay = date('d/m/Y', strtotime( $date ) );			
			
			if(isset($_POST['order_status']) && !empty($_POST['order_status'])){
				$order_status = sanitize_text_field( $_POST['order_status'] );
				print "<h3> ". esc_html__('Orders with Status',"webd-woocommerce-reporting-statistics") ." ".esc_html( $order_status )." </h3>";
			}
			if( isset($_POST['selected']) && !empty($_POST['selected'])){
				print "<h3>". esc_html__('Analysis for period',"webd-woocommerce-reporting-statistics")." ".date('d/m/Y',strtotime(esc_attr($_POST['selected'])))." to ". esc_html( $todayDisplay )."</h3>";	
				
			    $this->datediff = strtotime(date('Y-m-d')) - strtotime($_POST['selected']);
			    $this->datediff = abs(round( $this->datediff / (60 * 60 * 24)));
			
			}else{
                print "<h3>". esc_html__('This Month Analysis',"webd-woocommerce-reporting-statistics")."</h3>";
			    $this->datediff = strtotime( $today ) - strtotime(date('Y-m-01'));
			    $this->datediff = round( $this->datediff / (60 * 60 * 24));	
			
			} 
			if(isset($_POST['customer']) && !empty($_POST['customer'])){
				$user = get_user_by( 'id', $_POST['customer'] );
				print "<h3> for ". esc_html( $user->first_name ) . " " . esc_html( $user->last_name ) . " </h3>";
			}		
			?>
			</center>		
		<div class='flexmeContainer overview clearfix'>
		<?php
		
			
			$this->net = $this->subtotal - $this->refunds - $this->discounts;
			$this->saleEvery = $this->datediff / count( $this->uniqueDates );
			$this->avg = $this->divide( $this->subtotal  , $this->datediff  );

				print "<div class='report_widget'><h3><i class='fa fa-2x fa-signal' ></i> " . esc_html__( "TOTAL SALES", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->total ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-signal' ></i> " . esc_html__( "NET SALES", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->subtotal ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-signal' ></i> " . esc_html__( "SALES", "webd-woocommerce-reporting-statistics" )." | <small style='font-weight:normal'>after refunds&discounts</small><hr/><span> ". wc_price( $this->net ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-truck' ></i> " . esc_html__( "SHIPPING", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->shipping ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-percent' ></i> ". esc_html__( "TAXES", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->taxes ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-thumbs-down' ></i> " . esc_html__( "REFUNDS", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->refunds ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-tag' ></i> " . esc_html__( "DISCOUNTS", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( $this->discounts ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-pie-chart' ></i> " . esc_html__( "#PRODUCTS PURCHASED", "webd-woocommerce-reporting-statistics" )." <hr/> " . esc_html( $this->products ) ."</h3></div>";
				print "<div class='report_widget'><h3><i class='fa fa-2x fa-pie-chart' ></i> " . esc_html__( "#ORDERS", "webd-woocommerce-reporting-statistics" )." <hr/> ". esc_html( count( $this->orders ) ) ."</h3></div>";   
				print "<div class='report_widget em'><h3><i class='fa fa-2x fa-filter' ></i> " . esc_html__( "AVG NET SALES / day", "webd-woocommerce-reporting-statistics" )." <hr/> ". wc_price( esc_html( $this->avg ) ) ."</h3></div>"; 
				print "<div class='report_widget em'><h3><i class='fa fa-2x fa-clock-o' ></i> " . esc_html__( "SALES EVERY", "webd-woocommerce-reporting-statistics" )." <hr/> ". esc_html( floor( $this->saleEvery ) ) . esc_html__( " days", "webd-woocommerce-reporting-statistics" )."</h3></div>"; 
			?>
			</div>
			<?php
	}
	
	public function all_sales(){
			
		if( $this->total != 0 ){

		$this->overview();
		
		
		$sales = array();
		$orders=array();
		$products=array();
		$categories=array();
		$customers=array();
		$countries=array();
		$coupons=array();
		$payments=array();
				
        foreach ( $this->orders as $order ) {
			
			$orders[] = array('refund'=>$order['refund'],"orderid"=> $order['order_id'],"date"=>$order['date'],"quantity"=>$order['quantity'],"payment"=>$order['order_payment_method'],"amount"=>$order['total'], "refund"=>$order['refund'],"tax"=>$order['tax'], 'discount'=>$order['discount'], 'shipping'=>$order['shipping'],'name'=>$order['name'],'country'=>$order['country']  ,'company'=>$order['company'], 'coupons' => $this->get_coupon_used( $order['order_id'] ) ,'subtotal'=>$order['subtotal'] );

			$customers[] = array('refund'=>$order['refund'],"name"=>$order['name'],"phone"=>$order['phone'],"mail"=>$order['mail'],"country"=>$order['country'],"state"=>$order['state'],"city"=>$order['city'],'company'=>$order['company'],"quantity"=>$order['quantity'],"amount"=>$order['total'], "date"=>$order['date'] );
			
			$countries[] = array('refund'=>$order['refund'],"name"=>$order['country'],"amount"=>$order['total'],"quantity"=>'1' ,'subtotal'=>$order['subtotal'],"tax"=>$order['tax'] );
			
			$payments[] = array('refund'=>$order['refund'],"quantity"=>'1',"payment"=>$order['order_payment_method'],"amount"=>$order['total'] , "date"=>$order['date'] ,'subtotal'=>$order['subtotal'],"tax"=>$order['tax'] );
			
			$coupons[] = array("name"=>$this->get_coupon_used( $order['order_id'] ),"amount"=>$order['discount'] );
			
			
		}
		foreach ( $this->theproducts as $product ) {
		    $products[] = array('discount'=>$order['discount'],'refund'=>$order['refund'], "name"=>get_the_title( $product['id'] ),"quantity"=>$product['quantity'],"amount"=>$product['total'] , 'sku'=> get_post_meta( $product['id'], '_sku', true ) );
		
		    
			$terms = wp_get_post_terms( $product['product_id'],'product_cat');
			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
				if(count($terms) > 1){
					$showtotal=0;
				}else $showtotal=1;				
				foreach ( $terms as $term ) {
					$categories[] = array('discount'=>$order['discount'],'refund'=>$order['refund'],"name"=>$term->name,"quantity"=>$product['quantity'],"amount"=>$product['total'],"showtotal"=>$showtotal  );
				}					
			}		    
		}

		?>
		<div id="tabs2" class='clearfix'>
			<ul>
				<li><a href="#orders"><?php  esc_html_e( 'Orders',"webd-woocommerce-reporting-statistics" );?></a></li>				
				<li><a href="#customers"><?php  esc_html_e( 'Customers',"webd-woocommerce-reporting-statistics" );?></a></li>				
				<li><a href="#products"><?php  esc_html_e( 'Products',"webd-woocommerce-reporting-statistics" );?></a></li>
				<li><a href="#categories"><?php  esc_html_e( 'Categories',"webd-woocommerce-reporting-statistics" );?></a></li>
				<li><a href="#countries"><?php  esc_html_e( 'Countries',"webd-woocommerce-reporting-statistics" );?></a></li>
				<li><a href="#payment"><?php  esc_html_e( 'Payment Methods',"webd-woocommerce-reporting-statistics" );?></a></li>
				<li><a href="#coupons"><?php  esc_html_e( 'Coupons',"webd-woocommerce-reporting-statistics" );?></a></li>
				<li><a style='background-color: #f0f0f1;' href="#proVersion" class='proVersion'><?php  esc_html_e( 'Custom Report - pro',"webd-woocommerce-reporting-statistics" );?></a></li>
			</ul>

		<?php $this->orders( $orders ); ?>
		<?php $this->payments( $payments ); ?>
		<?php $this->customers( $customers ); ?>
		<?php $this->countries( $countries ); ?>
		<?php $this->products( $products ); ?>
		<?php $this->categories( $categories ); ?>
		<?php $this->coupons( $coupons ); ?>
		
		
		</div>		
		<?php
		
		}else{
			print "<center>";
			
			$date = current_time( 'mysql' ) ; 
			$today = date('d/m/Y', strtotime( $date ) ); 
			$todayDisplay = date('d/m/Y', strtotime( $date ) );	
			
        	if( isset( $_POST['order_status'] ) && !empty( $_POST['order_status'] ) ){
        		$order_status = sanitize_text_field( $_POST['order_status'] ); 
        	}else{
				$order_status = 'completed';	
        		$orderstatus = 'completed';	
        	}
			
			if( isset($_POST['selected']) && !empty($_POST['selected'])){
				print "<h3>".esc_html__('No ',"webd-woocommerce-reporting-statistics") . esc_html($order_status ) . esc_html__(' orders for ',"webd-woocommerce-reporting-statistics").date('d/m/Y',strtotime(esc_attr($_POST['selected'])))." to ". esc_html( $today ) ."</h3>";			
			}else print "<h3>".esc_html__('No ',"webd-woocommerce-reporting-statistics") . esc_html( $order_status ) . esc_html__(' orders for ',"webd-woocommerce-reporting-statistics").date('F')." </h3>";	

				
			if(isset($_POST['customer']) && !empty($_POST['customer'])){
				$user = get_user_by( 'id', $_POST['customer'] );
				print "<h3> for ". esc_html( $user->first_name." " .$user->last_name ) . " </h3>";
			}
			if(isset($_POST['order_status']) && !empty($_POST['order_status'])){
				$order_status = sanitize_text_field( $_POST['order_status'] );
				print "<h3> ". esc_html__('No Orders with Status',"webd-woocommerce-reporting-statistics") ." ".esc_html( $order_status )." </h3>";
			}			
			print "</center>";	
		}
	
	}

	public function orders($orders){?>

		<div class='column1' id='orders'>
		<?php if($orders){ ?>
		<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e( 'ORDERS PLACED',"webd-woocommerce-reporting-statistics" );?> </h3>
		
		
		<table class="widefat striped ordersToExport" >
			<thead>
			   <tr class="row-title">
					<th><?php  esc_html_e( 'Order ID',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Date',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Payment Method',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Coupons',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Cust Name',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Cust Country',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Cust Company',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Net Sales',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Discount',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Shipping Cost',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Refunds',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Taxes',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Total of Sales',"webd-woocommerce-reporting-statistics" );?></th>	
				</tr>
			</thead>		
			<tbody>
		<?php
			$result = array();	
			$totalAmount=0;
			$totalAmount=0;
			$totalQuantity=0;
			$totalShipping=0;
			$totalDiscount=0;
			$totalRefund=0;
			$totalSub=0;
			$totalTax=0;
			foreach($orders as $item){			
				print "<tr>";

				$item['country']!='' ? $item['country'] = WC()->countries->countries[esc_attr($item['country'])] : $item['country']='';
				$item['orderid']!='' ?  : $item['orderid']='';
				$item['date']!='' ? : $item['date']='';
				$item['payment']!='' ? : $item['payment']='';
				$item['coupons']!='' ? : $item['coupons']='';
				$item['name']!='' ? : $item['name']='';
				$item['subtotal']!='' ? : (float)$item['subtotal']='';
				$item['discount']!='' ? : (float)$item['discount']='';
				$item['shipping']!='' ? : (float)$item['shipping']='';
				$item['refund']!='' ? : (float)$item['refund']='';
				$item['tax']!='' ? : (float)$item['tax']='';	

                $total = (float)$item['amount'] - (float)$item['refund'];
				$totalAmount += (float)$item['amount']- (float)$item['refund'];
				$totalShipping += (float)$item['shipping'];
				$totalDiscount += (float)$item['discount'];
				$totalRefund += (float)$item['refund'];
				$totalSub += (float)$item['subtotal'];
				$totalTax += (float)$item['tax'];
				
				echo "<td>";
					
					?>
					<a target='blank' href="<?php print admin_url( "/admin.php?page=wc-orders&action=edit&id=".$item['orderid'] );?>"><?=$item['orderid']; ?></a>
					<?php						
										
				?>
				
				<?php echo "</td><td>". date(" d/m/Y", strtotime($item['date'] ) ). "</td><td>". esc_html( $item['payment'] ). "</td><td>" . esc_html( $item['coupons'] ). "</td><td>" . esc_html( $item['name'] ). "</td><td>" . esc_html( $item['country'] ). "</td><td>" . esc_html( $item['company'] ). "</td><td>". wc_price( $item['subtotal'] ) . "</td><td>". wc_price($item['discount']) . "</td><td>". wc_price($item['shipping']) . "</td><td>". wc_price($item['refund']) . "</td><td>". wc_price($item['tax']) . "</td><td>". wc_price($total) . "</td>";	
				print "</tr>";
				
			}
			echo "<tr class='totals'><td>" . esc_html__( 'TOTALS',"webd-woocommerce-reporting-statistics" )."</td><td></td><td></td><td></td><td></td><td></td><td></td><td>".wc_price( $totalSub )."</td><td>".wc_price( $totalDiscount )."</td><td>".wc_price( $totalShipping )."</td><td>".wc_price( $totalRefund )."</td><td>".wc_price( $totalTax )."</td><td>".wc_price( $totalAmount )."</td></tr>";			
		?>
		   </tbody>
		   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search "  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
		</table>
		
		<?php }else print "<h3>".esc_html__('No data for orders',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>	
	<?php
	}
	
	public function payments($payments){
	?>
		<div id='payment'>
		<?php if( $payments ){ ?>
		
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-money' ></i> <?php  esc_html_e( 'PAYMENT METHODS',"webd-woocommerce-reporting-statistics" );?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e( 'Payment Method',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Orders',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Net Sales',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Tax',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Total Sales',"webd-woocommerce-reporting-statistics" );?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$paySales = array_column($payments, 'amount');
				$returnPay = array_multisort($paySales, SORT_DESC , $payments);			
				//GROUP BY PAYMENT METHOD
				$result = array();		
				foreach ($payments as $element) {
				   $result[$element['payment']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalSubtotal=0;
				$totalTax=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					$subtotal=0;
					$tax=0;
					foreach ($res as $item) {

						$am += (float)$item['amount'] - (float)$item['refund'];
						$subtotal += (float)$item['subtotal'];
						$tax += (float)$item['tax'];
						$quant += (float)$item['quantity'];
					}
					$totalAmount += $am;
					$totalSubtotal+= $subtotal;
					$totalTax+= $tax;
					$totalQuantity+= $quant;
					
						$reportPayment[] = array("name"=>$item['payment'],"payment"=>$am );
						
					echo "<td>". esc_html( $item['payment'] ). "</td><td>". esc_html( $quant ) . "</td><td>". wc_price( $subtotal ) . "</td><td>". wc_price( $tax ) . "</td><td>". wc_price( $am ) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>".esc_html__( 'TOTALS',"webd-woocommerce-reporting-statistics" )."</td><td>". esc_html( $totalQuantity )."</td><td>".wc_price( $totalSubtotal )."</td><td>".wc_price( $totalTax )."</td><td>".wc_price( $totalAmount )."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search"  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>
				<div class="chart-container columns2" style="position: relative">
					<canvas id="byPayment"></canvas>
				</div>

				<script>
				var ctx = document.getElementById("byPayment");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach($reportPayment as $t){print '"' .esc_attr($t['name']) . '",';};?>],
						datasets: [{
							label: 'Sales',
							data: [<?php foreach($reportPayment as $t){print '"' .esc_attr($t['payment']) . '",';};?>],			
							backgroundColor: [
								<?php foreach($reportPayment as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [
								<?php foreach($reportPayment as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},
					options: {
						title: {
							display: true,
							text: 'Payment Methods'
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
				</script>
		<?php }else print "<h3>".esc_html__('No data for payments',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>
	<?php
	}
	
	public function customers($customers){
		?>
		<div class='column1' id='customers'>
		<?php if( $customers ){ ?>
		<h3 class='text-center'><i class='fa fa-users' ></i> <?php  esc_html_e( 'CUSTOMERS',"webd-woocommerce-reporting-statistics" );?> </h3>
		<table class="widefat striped" id='custs'>
			<thead>
			   <tr class="row-title">
					<th><?php  esc_html_e( 'Customer Name',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Phone',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Email',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Country',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'State',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'City',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Company',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Quantity',"webd-woocommerce-reporting-statistics" );?></th>
					<th><?php  esc_html_e( 'Sales',"webd-woocommerce-reporting-statistics" );?></th>
				</tr>
			</thead>		
			<tbody>
		<?php
			//SORT ARRAY BY VALUE DESCENDING
			$custSales = array_column($customers, 'amount');
			$returnCust = array_multisort($custSales, SORT_DESC , $customers);		
			//GROUP BY CUSTOMER
			$result = array();		
			foreach ($customers as $element) {
			   $result[$element['name']][] = $element;
			}
			//run the loop, sum the salaries by gender
			$totalAmount=0;
			$totalQuantity=0;
			foreach($result as $res){			
				print "<tr>";
				/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
				$am = 0;
				$quant=0;
				foreach ($res as $item) {
					
					$item['name']!='' ? : $item['name']='';
					$item['phone']!='' ? : $item['phone']='';
					$item['mail']!='' ? : $item['mail']='';
					$item['country']!='' ? : $item['country']='';
					$item['state']!='' ? : $item['state']='';
					$item['city']!='' ? : $item['city']='';
					$item['company']!='' ? : $item['company']='';
					$item['quantity']!='' ? : $item['quantity']='';
				
					$am += (float)$item['amount'] - (float)$item['refund'];
					$quant += (float)$item['quantity'];

				}
				$totalAmount+= (float)$am;
				$totalQuantity+= (float)$quant;
									
				echo "<td>".esc_html( $item['name'] ). "</td><td>". esc_html( $item['phone'] ). "</td><td>". esc_html( $item['mail'] ). "</td><td>".WC()->countries->countries[$item['country']]. "</td><td>". esc_html( $item['state'] ). "</td><td>". esc_html( $item['city'] ) . "</td><td>". esc_html(  $item['company'] ). "</td><td>". esc_html(  $quant  ). "</td><td>". wc_price($am) . "</td>";	
				print "</tr>";
				
			}
			echo "<tr class='totals'><td>".esc_html__( 'TOTALS',"webd-woocommerce-reporting-statistics" )."</td><td></td><td></td><td></td><td></td><td></td><td></td><td>". esc_html( $totalQuantity )."</td><td>".wc_price($totalAmount)."</td></tr>";			
		?>
		   </tbody>
		   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search"  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
		</table>
		<?php }else print "<h3>".esc_html__('No data for customers',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>		
	<?php
	
	}
	
	
	public function countries($countries){
		?>
	
		<div  id='countries'>
		<?php if($countries){ ?>
			<div class='columns2' >
			<h3 class='text-center'><i class='fa fa-globe' ></i> <?php  esc_html_e( 'COUNTRIES',"webd-woocommerce-reporting-statistics" );?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Country',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Orders',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Net Sales',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Tax',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Total Sales',"webd-woocommerce-reporting-statistics");?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$countSales = array_column($countries, 'amount');
				$returnCount = array_multisort($countSales, SORT_DESC , $countries);		
			
				//GROUP BY country
				$result = array();		
				foreach ($countries as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalSubtotal=0;
				$totalTax=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					$subtotal=0;
					$tax=0;
					foreach ($res as $item) {
						$am += (float)$item['amount'] - (float)$item['refund'];
						$subtotal += (float)$item['subtotal'];
						$tax += (float)$item['tax'];
						$quant += (float)$item['quantity'];

					}
					$totalAmount+= $am;
					$totalSubtotal+= $subtotal;
					$totalTax+= $tax;
					$totalQuantity+= $quant;
					$item['name']!='' ? $item['name'] = WC()->countries->countries[esc_attr($item['name'])] : $item['name']='';
					
						$reportCountries[] = array("name"=>$item['name'],"quantity"=>$quant,"payment"=>$am );
						
					echo "<td>" . esc_html( $item['name'] ). "</td><td>". esc_html( $quant ) . "</td><td>". wc_price( $subtotal ) . "</td><td>". wc_price( $tax ) . "</td><td>". wc_price( $am ) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>". esc_html__('TOTALS',"webd-woocommerce-reporting-statistics")."</td><td>" . esc_html( $totalQuantity )."</td><td>".wc_price( $totalSubtotal )."</td><td>".wc_price( $totalTax )."</td><td>".wc_price( $totalAmount )."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search "  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>		
				<div class="chart-container columns2" >
					<canvas id="byCountry"></canvas>
				</div>

				<script>
				var ctx = document.getElementById("byCountry");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach($reportCountries as $t){print '"' .esc_attr($t['name']) . '",';};?>],
						datasets: [{
							label: [<?php foreach($reportCountries as $t){print '"' .esc_attr($t['name']) . '",';};?>],
							data: [<?php foreach($reportCountries as $t){print '"' .esc_attr($t['payment']) . '",';};?>],			
							backgroundColor: [
								<?php foreach($reportCountries as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [
								<?php foreach($reportCountries as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},
					options: {
						title: {
							display: true,
							text: 'Countries'
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
				</script>
		<?php }else print "<h3>".esc_html__('No data for countries',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>	
	<?php
	}
	
	public function products($products){ 
	?>
		<div id='products'>
		<?php if($products){ ?>
			<div class='column1'>
			<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e( 'PRODUCTS',"webd-woocommerce-reporting-statistics" );?></h3>
			<center><i><?php esc_html_e( "Amounts before tax and total discount" ,"webd-woocommerce-reporting-statistics" ); ?></i><center>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e( 'Product',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'SKU',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Items Sold',"webd-woocommerce-reporting-statistics" );?></th>						
						<th><?php  esc_html_e( 'Sales',"webd-woocommerce-reporting-statistics" );?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
		
				//SORT ARRAY BY VALUE DESCENDING
				$prodSales = array_column($products, 'amount');
				$returnProd = array_multisort($prodSales, SORT_DESC , $products);
				
				//GROUP BY products
				$result = array();		
				foreach ($products as $element) {
				   $result[$element['name']][] = $element;
				}
				
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalRefund = 0;
				
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					foreach ($res as $item) {
						$am += (float)$item['amount']-(float)$item['refund']-(float)$item['discount'];
						$quant += (float)$item['quantity'];
                        $totalRefund= (float)$item['refund'];
					}
					$totalAmount+= (float)$am;
					$totalQuantity+= (float)$quant;
					
						$reportProducts[] = array("name"=>$item['name'],"quantity"=>$am,"amount"=>$am );
						
					echo "<td>" . esc_html( $item['name'] ). "</td><td>". esc_html( $item['sku'] ). "</td><td>". esc_html( $quant ) . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>".esc_html__( 'TOTALS',"webd-woocommerce-reporting-statistics" )."</td><td></td><td>". esc_html( $totalQuantity )."</td><td>" . wc_price( $totalAmount )."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search"  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>		
			<div class="chart-container" >
				<canvas id="productChart"></canvas>
			</div>

			<script>
			var ctx = document.getElementById("productChart");
			var myChart = new Chart(ctx, {
				type: 'bar',
				data: {
					labels: [<?php foreach($reportProducts as $p){print '"' . esc_attr($p['name']) . '",';};?>],
					datasets: [{
						label: '# of Sales',
						data: [<?php foreach($reportProducts as $p){print '"' . esc_attr($p['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportProducts as $p){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportProducts as $p){print '"' .$this->getRandomColor(). '",';};?>],				
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'PRODUCTS'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>
			
		<?php }else print "<h3>".esc_html__('No data for products',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>		
	<?php

	}
	
	public function categories($categories){
			
	?>
		<div id='categories'>
		<?php if($categories){ ?>
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e( 'CATEGORIES',"webd-woocommerce-reporting-statistics" );?></h3>
			<center><i><?php esc_html_e( "Amounts before tax and total discount","webd-woocommerce-reporting-statistics" ); ?></i></center>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e( 'Category',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Items Sold',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Sales',"webd-woocommerce-reporting-statistics" );?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$catSales = array_column($categories, 'amount');
				$returnCat = array_multisort($catSales, SORT_DESC , $categories);		
				//GROUP BY products
				$result = array();		
				foreach ($categories as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalRefund=0;
				$showtotal =1;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					
					foreach ($res as $item) {
					    $am += (float)$item['amount']-(float)$item['refund']-(float)$item['discount'];
						$quant += (float)$item['quantity'];
                         $totalRefund= $item['refund'];
						 if( $item['showtotal']  == 0 ){
							 $showtotal =0;
						 }
					}
					$totalAmount+= $am;
					$totalQuantity+= $quant;
					
						$reportCategories[] = array("name"=>$item['name'],"amount"=>$am );
						
					echo "<td>". esc_html( $item['name'] ) . "</td><td>". esc_html( $quant ) . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}
				if( $showtotal == 1 ) echo "<tr class='totals'><td>". esc_html__('TOTALS',"webd-woocommerce-reporting-statistics" ). "</td><td>" . esc_html( $totalQuantity ) . "</td><td>" . wc_price( $totalAmount ) . "</td></tr>";			
			?>
			   </tbody>
			   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search "  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>
			<div class="chart-container columns2" >
				<canvas id="couponCategories"></canvas>
			</div>
			<script>
			var ctx = document.getElementById("couponCategories");
			var myChart = new Chart(ctx, {
				type: 'pie',
				data: {
					labels: [<?php foreach($reportCategories as $rep){print '"' . esc_attr($rep['name']) . '",';};?>],
					datasets: [{
						label: '',
						data: [<?php foreach($reportCategories as $rep){print '"' .  esc_attr($rep['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportCategories as $rep){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportCategories as $rep){print '"' .$this->getRandomColor(). '",';};?>],					
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'Categories'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>			
		<?php }else print "<h3>".esc_html__('No data for categories',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>	
	
	<?php	

	}
	
	public function coupons($coupons){	
		?>
		<div id='coupons'>
		<?php if($coupons){ ?>
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e( 'COUPONS',"webd-woocommerce-reporting-statistics" );?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e( 'Coupon',"webd-woocommerce-reporting-statistics" );?></th>
						<th><?php  esc_html_e( 'Total',"webd-woocommerce-reporting-statistics" );?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$coupSales = array_column($coupons, 'amount');
				$returnCoup = array_multisort($coupSales, SORT_DESC , $coupons);				
				//GROUP BY coupons
				$result = array();	
				foreach ($coupons as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					foreach ($res as $item) {
						$am += (float)$item['amount'];
						//$quant += $item['quantity'];
					}				
					$totalAmount+= (float)$am;
					//$totalQuantity+= $quant;
					$reportCoupons[] = array("name"=>$item['name'],"amount"=>$am );
					echo "<td>". esc_html( $item['name'] ) . "</td><td>". wc_price( $am ) . "</td>";	
					print "</tr>";
					
				}			
				echo "<tr class='totals'><td>".esc_html__( 'TOTALS',"webd-woocommerce-reporting-statistics" )."</td><td>".wc_price( $totalAmount )."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search"  placeholder="<?php  esc_html_e('Search...',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>	
			<div class="chart-container columns2" >
				<canvas id="couponCharts"></canvas>
			</div>
			<script>
			var ctx = document.getElementById("couponCharts");
			var myChart = new Chart(ctx, {
				type: 'pie',
				data: {
					labels: [<?php foreach($reportCoupons as $rep){print '"' . esc_attr($rep['name']) . '",';};?>],
					datasets: [{
						label: '',
						data: [<?php foreach($reportCoupons as $rep){print '"' .  esc_attr($rep['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportCoupons as $rep){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportCoupons as $rep){print '"' .$this->getRandomColor(). '",';};?>],					
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'Coupons'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>	
		<?php }else print "<h3>".esc_html__('No data for coupons',"webd-woocommerce-reporting-statistics")."</h3>"; ?>
		</div>	
	<?php
	
	}
	
	public function topSellers(){
			global $woocommerce;		
            include_once(WC()->plugin_path().'/includes/admin/reports/class-wc-admin-report.php');
                $wc_report = new WC_Admin_Report();
 
                $data = $wc_report->get_order_report_data( array(
                    'data' => array(
                        '_qty' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => 'SUM',
                            'name' => 'quantity'
                        ),
                        '_line_subtotal' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => 'SUM',
                            'name' => 'gross'
                        ),
                        '_product_id' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => '',
                            'name' => 'product_id'
                        ),
                        'order_item_name' => array(
                            'type'     => 'order_item',
                            'function' => '',
                            'name'     => 'order_item_name',
                        ),
                    ),           
                    'group_by'     => 'product_id',           
                    'order_by'     => 'quantity DESC',           
                    'query_type' => 'get_results',
            
                    'limit' => 5,
                    'order_types' => wc_get_order_types( 'order_count' ),
                    'order_status' => array( 'completed','processing','onhold','refunded'),
                ) );
				
				if(!empty($data)){
                ?><br/><hr/>
				<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e('ALL TIMES TOP 5 SELLING PRODUCTS',"webd-woocommerce-reporting-statistics");?></h3>
                <table class='widefat striped'>
                    <thead>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Category',"webd-woocommerce-reporting-statistics");?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Product',"webd-woocommerce-reporting-statistics");?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Quantity',"webd-woocommerce-reporting-statistics");?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Sales',"webd-woocommerce-reporting-statistics");?></th>
                    </thead>
               
                    <tbody>
                        
                    <?php
                    foreach($data as $d){
                        $terms = wp_get_post_terms( $d->product_id, 'product_cat' );
                        print "<tr><td>";
                        foreach ( $terms as $term ) {
                             $cat_id = $term->name;
                             print $term->name ."<br/>";
                             
                        }
                        //$d->product_id 
                        print "</td>";
                        print "<td>".esc_attr($d->order_item_name) . "</td><td>".esc_attr($d->quantity)."</td><td>" .wc_price(esc_attr($d->gross)) ."</td>" ;
                        print "</tr>";
                    }
                    ?>
                    </tbody>
                 </table>                
                <?php 
				}else print esc_html__("There is no sale yet!","webd-woocommerce-reporting-statistics");
	}		
		

	public function LowStock(){
			?>
		<div id='noselling'>
			<div class='column1'>
			<h3 class='text-center title'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('All Time Low Stock Products( < 5 items )',"webd-woocommerce-reporting-statistics");?></h3>
			<table class='widefat'>
			<thead>
				<tr>
					<th><?php  esc_html_e('Title',"webd-woocommerce-reporting-statistics");?></th>
					<th><?php  esc_html_e('Stock',"webd-woocommerce-reporting-statistics");?></th>
					<th><?php  esc_html_e('Sales',"webd-woocommerce-reporting-statistics");?></th>
				</tr>
			</thead>
			<tbody>
			<tr><td rowspan="3"><h1 class='proVersion'><a href='#'><?php  esc_html_e('PRO VERSION ONLY- get it Here!',"webd-woocommerce-reporting-statistics");?></a></h1></td></tr>
		</tbody> 
		 <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',"webd-woocommerce-reporting-statistics");?>"></input>
		</table>
		</div>
	<?php	
	}

    private function get_coupon_used( $order_id ) {
		
		if ( wc_coupons_enabled() ) {
			
			$order = wc_get_order( $order_id );
			if ( version_compare( WC()->version, '3.7', '>=' ) ) {
				$coupons = $order->get_coupon_codes();
			}else{
				$coupons = $order->get_used_coupons();
			}		

			if (!empty( $coupons ) ) {
				return implode( ', ', $coupons );
			} else {
				return '';
			}
		
		}else return  '';
    }
	
	public function divide($a, $b){
		try {
			if(@($a / $b) === false) return INF; // covers PHP5
			return @($a / $b); // covers PHP7
		} catch (DivisionByZeroError $e) {
			return INF; // covers PHP8
		}
	}
	
	public function sellingProdStock(){
		?>
		<div id='selling'>
			<div class='column1'>
			<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('Last 30 days Selling Products Stock Reminder',"webd-woocommerce-reporting-statistics");?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Product',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Items Sold',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('In Stock',"webd-woocommerce-reporting-statistics");?></th>						
						<th><?php  esc_html_e('Sales Amount',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Sales Every (days)',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Avg Quantity Sold / Order',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Next Order Forecasted Quantity',"webd-woocommerce-reporting-statistics");?></th>
						<th><?php  esc_html_e('Days Left to Out of Stock',"webd-woocommerce-reporting-statistics");?></th>
					</tr>
				</thead>		
				<tbody>
					<tr><td rowspan="8"><h1 class='proVersion '><a href='#'><?php  esc_html_e('PRO VERSION ONLY- get it Here!',"webd-woocommerce-reporting-statistics");?></a></h1></td></tr>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',"webd-woocommerce-reporting-statistics");?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',"webd-woocommerce-reporting-statistics");?>"></input>
			</table>
			</div>	
		</div>
		<?php
	}	
	
	public function forecastHoltWinters($anData, $nForecast = 2, $nSeasonLength = 4, $nAlpha = 0.2, $nBeta = 0.01, $nGamma = 0.01, $nDevGamma = 0.1) {
		$search = '0';
		$replace = '0.1';
		array_walk($anData,
			function (&$v) use ($search, $replace){
				$v = str_replace($search, $replace, $v);    
			}                                                                     
		);	
		
		$i=1;
		// Calculate an initial trend level
		$nTrend1 = '';
		for($i = 0; $i < $nSeasonLength; $i++) {
			$anData[$i] = isset($anData[1]) ? $anData[1] : null;
		    //$nTrend1 += $anData[$i];
		}
		$nTrend1 = $nSeasonLength;

		$nTrend2 = 1;
		for($i = $nSeasonLength; $i < 2*$nSeasonLength; $i++) {
			$anData[$i] = isset($anData[1]) ? $anData[1] : null;
		  $nTrend2 += $anData[$i];
		}
		$nTrend2 /= $nSeasonLength;

		$nInitialTrend = ($nTrend2 - $nTrend1) / $nSeasonLength;

		// Take the first value as the initial level
		$nInitialLevel = $anData[0];

		// Build index
		$anIndex = array();
		foreach($anData as $nKey => $nVal) {
			$anIndex[$nKey] = $nVal / ($nInitialLevel + ($nKey + 1) * $nInitialTrend);		  
		}

		// Build season buffer
		$anSeason = array_fill(0, count($anData), 0);
		for($i = 0; $i < $nSeasonLength; $i++) {
		  $anSeason[$i] = ($anIndex[$i] + $anIndex[$i+$nSeasonLength]) / 2;
		}

		// Normalise season
		 $Total = array_sum($anSeason);
		 $Total = isset($Total) & !empty($Total) ? $Total : '0.1';
		 
		$nSeasonFactor = $nSeasonLength / $Total;
		foreach($anSeason as $nKey => $nVal) {
		  $anSeason[$nKey] *= $nSeasonFactor;
		}

		$anHoltWinters = array();
		$anDeviations = array();
		$nAlphaLevel = $nInitialLevel;
		$nBetaTrend = $nInitialTrend;
		foreach($anData as $nKey => $nVal) {
		  $nTempLevel = $nAlphaLevel;
		  $nTempTrend = $nBetaTrend;

		  $nAlphaLevel = @($nAlpha * $nVal / $anSeason[$nKey]) + (1.0 - $nAlpha) * ($nTempLevel + $nTempTrend);
		  $nBetaTrend = $nBeta * ($nAlphaLevel - $nTempLevel) + ( 1.0 - $nBeta ) * $nTempTrend;

		  $anSeason[$nKey + $nSeasonLength] = $nGamma * $nVal / $nAlphaLevel + (1.0 - $nGamma) * $anSeason[$nKey];

		  $anHoltWinters[$nKey] = ($nAlphaLevel + $nBetaTrend * ($nKey + 1)) * $anSeason[$nKey];
		  $anDeviations[$nKey] = $nDevGamma * abs($nVal - $anHoltWinters[$nKey]) + (1-$nDevGamma) 
					  * (isset($anDeviations[$nKey - $nSeasonLength]) ? $anDeviations[$nKey - $nSeasonLength] : 0);
		}

		$anForecast = array();
		$nLast = end($anData);
		for($i = 1; $i <= $nForecast; $i++) {
		   $nComputed = round($nAlphaLevel + $nBetaTrend * $anSeason[$nKey + $i]);
		   if ($nComputed < 0) { // wildly off due to outliers
			 $nComputed = $nLast;
		   }
		   $anForecast[] = $nComputed;
		}

		return $anForecast;
	}
	
	public function Median($Array) {
	  return Quartile_50($Array);
	}
	 
	public function Quartile_25($Array) {
	  return Quartile($Array, 0.25);
	}
	 
	public function Quartile_50($Array) {
	  return Quartile($Array, 0.5);
	}
	 
	public function Quartile_75($Array) {
	  return Quartile($Array, 0.75);
	}
	 
	public function Quartile($Array, $Quartile) {
	  $pos = (count($Array) - 1) * $Quartile;
	 
	  $base = floor($pos);
	  $rest = $pos - $base;
	 
	  if( isset($Array[$base+1]) ) {
		return $Array[$base] + $rest * ($Array[$base+1] - $Array[$base]);
	  } else {
		return $Array[$base];
	  }
	}
	 
	public function Average($Array) {
	  return array_sum($Array) / count($Array);
	}
	 
	public function StdDev($Array) {
	  if( count($Array) < 2 ) {
		return;
	  }
	 
	  $avg = Average($Array);
	 
	  $sum = 0;
	  foreach($Array as $value) {
		$sum += pow($value - $avg, 2);
	  }
	 
	  return sqrt((1 / (count($Array) - 1)) * $sum);
	}

	public function random_color_part() {
		return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT);
	}

	public function getRandomColor() {
		return "#".$this->random_color_part() . $this->random_color_part() . $this->random_color_part();
	}
	
	public function extensions(){
		
		if( is_admin() && current_user_can( 'administrator' ) ){
			
			$response = wp_remote_get( "https://extend-wp.com/wp-json/products/v2/product/category/excel" );
			if( is_wp_error( $response ) ) {
				return;
			}		
			$posts = json_decode( wp_remote_retrieve_body( $response ) );

			if( empty( $posts ) ) {
				return;
			}

			if( !empty( $posts ) ) {
				echo "<div id='extendwp_extensions_popup'>";
					echo "<div class='extendwp_extensions_content '>";	
						?>
						<span class="extendwp_close">&times;</span>
						<h2><i><?php esc_html_e( 'More Plugins to Make your life easier by ExtendWP!', "webd-woocommerce-reporting-statistics" ); ?></i></h2>
						<hr/>
						<?php
						print "<div class='extend_flex'>";
						foreach( $posts as $post ) {
							
							if( $post->class == 'webdWoocommerceReportingStatisticsPro'   ){
								

							}else{
								
								echo "<div class='columns3'><a target='_blank' href='".esc_url( $post->url )."' /><img src='".esc_url( $post->image )."' /></a>
								<h3><a target='_blank' href='".esc_url( $post->url )."' />". esc_html( $post->title ) . "</a></h3>
								<div>". wp_kses( $post->excerpt, $this->allowed_html )."</div>
								<a class='button_extensions button-primary' target='_blank' href='".esc_url( $post->url )."' />". esc_html__( 'Get it here', "webd-woocommerce-reporting-statistics" ) . " <i class='fa fa-angle-double-right'></i></a>
								</div>";								
							}
							

						}
						print "</div>";
					echo '</div>';
				echo '</div>';	
			}
		
		}
	}	
 }