<?php

namespace QuadLayers\WP_Dashboard_Widget_News;

class Load {

	protected static $instance;
	private $utm_source = 'utm_source=WordPress&utm_medium=dashboard&utm_campaign=widget';

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'wp_network_dashboard_setup', array( $this, 'add_dashboard_widget' ), -10 );
			add_action( 'wp_dashboard_setup', array( $this, 'add_dashboard_widget' ), -10 );
		}
	}

	public function add_dashboard_widget() {
		wp_add_dashboard_widget(
			'wp-dashboard-widget-news',
			'QuadLayers News',
			array(
				$this,
				'display_dashboard_widget',
			)
		);
	}

	public function display_dashboard_widget() {
		$posts = $this->get_feed();
		?>
		<div>
			<div>
				<div style="margin-top: 11px;float: left;width: 70%;">
					<?php esc_html_e( 'Hi! We are Quadlayers! We’re a team of international people who have been working in the WordPress sphere for the last ten years.', 'wp-dashboard-widget-news' ); ?>
					<div style="margin-top: 11px; float: left; width: 70%;">
					<a href="<?php printf( 'https://quadlayers.com/shop/?%s', $this->utm_source ); ?>" target="_blank" class="button button-secondary">
						<?php esc_html_e( 'More products', 'wp-dashboard-widget-news' ); ?>
					</a>
				</div>
			</div>
				<img style="width: 30%;margin-top: 11px;float: right; max-width: 95px;" src="data:image/jpeg;base64,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" />
			</div>
			<div style="clear: both;"></div>
		</div>
		<div style="margin: 16px -12px 0; padding: 12px 12px 0;border-top: 1px solid #eee;">
			<ul>
				<?php if ( is_array( $posts ) ) { ?>
					<?php
					foreach ( $posts  as $post ) {

						$link = $post['link'];
						while ( stristr( $link, 'http' ) !== $link ) {
							$link = substr( $link, 1 );
						}

						$link  = esc_url( strip_tags( $link . '?' . $this->utm_source ) );
						$title = esc_html( trim( strip_tags( $post['title'] ) ) );

						if ( empty( $title ) ) {
							$title = esc_html__( 'Untitled', 'wp-dashboard-widget-news' );
						}

						$excerpt = esc_attr( wp_trim_words( $post['excerpt'], 15, '...' ) );
						$summary = '<p class="rssSummary">' . $excerpt . '</p>';
						$date    = $post['date'];
						if ( $date ) {
							$date = ' - <span class="rss-date">' . date_i18n( get_option( 'date_format' ), $date ) . '</span>';
						}

						printf(
							'<li><strong><a href="%1$s" target="_blank">%2$s</a></strong>%3$s%4$s</li>',
							wp_kses_post( $link ),
							wp_kses_post( $title ),
							wp_kses_post( $date ),
							wp_kses_post( $summary )
						);
					}
					?>
					<?php
				} else {
					printf( '<li>%s</li>', $posts );
				}
				?>
			</ul>
		</div>
		<div style="display: flex; justify-content: space-between;align-items: center;margin: 16px -12px 0;padding: 12px 12px 0; border-top: 1px solid #eee;">
			<a href="<?php printf( 'https://quadlayers.com/blog/?%s', $this->utm_source ); ?>" target="_blank">
				<?php esc_html_e( 'Read more like this on our blog', 'wp-dashboard-widget-news' ); ?>
			</a>
			<a class="button-primary" href="<?php printf( 'https://quadlayers.com/?%s', $this->utm_source ); ?>" target="_blank">
				QuadLayers
			</a>
		</div>
		<?php
	}

	public function get_feed() {

		$posts = get_transient( 'quadlayers_news_feed' );

		if ( false === $posts ) {

			$response = wp_remote_get( 'https://quadlayers.com/wp-json/wp/v2/posts?categories=1&per_page=3' );

			if ( is_wp_error( $response ) || ! isset( $response['body'] ) ) {
				return esc_html__( 'An error has occurred, which probably means the feed is down. Try again later', 'wp-dashboard-widget-news' );
			}

			$posts_array = json_decode( wp_remote_retrieve_body( $response ), true );

			if ( ! is_array( $posts_array ) ) {
				return esc_html__( 'An error has occurred, which probably means the feed is down. Try again later', 'wp-dashboard-widget-news' );
			}

			$posts = array();

			foreach ( $posts_array as $post ) {
				$posts[] = array(
					'link'    => $post['link'],
					'title'   => $post['title']['rendered'],
					'excerpt' => $post['excerpt']['rendered'],
					'date'    => strtotime( $post['date'], time() ),
				);
			}

			set_transient( 'quadlayers_news_feed', $posts, DAY_IN_SECONDS );
		}

		return $posts;
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
