<?php
/*
 * Plugin Name: Advanced WooCommerce Product Sales Reporting - Statistics & Forecast
 * Plugin URI: https://extend-wp.com/advanced-reporting-statistics-plugin-for-woocommerce/
 * Description: A comprehensive WordPress Plugin for WooCommerce Reports, Statistics, Analytics & Forecasting Tool for Orders, Sales, Products, Countries, Payment Gateways Shipping, Tax, Refunds, Top Products.
 * Version: 1.6
 * Author: extendWP
 * Author URI: https://extend-wp.com
 *
 * WC requires at least: 2.2
 * WC tested up to: 7.3
 * 
 * License: GPL2
 * Created On: 23-01-2019
 * Updated On: 26-01-2023
 */
 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

include_once( plugin_dir_path(__FILE__) ."/class-admin.php"); 
 
 class webdWoocommerceReportingStatistics extends webdWoocommerceReportingStatisticsAdmin{
		
		public $plugin = 'webdWoocommerceReportingStatistics';		
		public $name = 'Webd Woocommerce Advanced Reporting & Statistics';
		public $shortName = 'Reporting & Statistics';
		public $slug = 'webd-woocommerce-reporting-statistics';
		public $dashicon = 'dashicons-editor-table';
		public $proUrl = 'https://extend-wp.com/product/woocommerce-advanced-reporting-statistics/';
		public $menuPosition ='50';
		public $localizeBackend;
		public $localizeFrontend;
		public $description = 'Advanced Reporting Analytics and Statistical Analysic to manage Woocommerce Eshop efficiently.';
			
 
		public function __construct() {
			
			add_action('admin_enqueue_scripts', array($this, 'BackEndScripts') );
			add_action('admin_menu', array($this, 'SettingsPage') );
			add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array($this, 'Links') );
						
			
			register_activation_hook( __FILE__,  array($this, 'onActivation') );
			register_deactivation_hook( __FILE__,  array($this, 'onDeactivation') );
			
			add_action('plugins_loaded', 'translate');	
			add_action("admin_init", array($this, 'settingsSection') );				
			add_action("admin_footer", array($this,"proModal" ) );

			add_action( 'wp_ajax_nopriv_stat_extensions', array( $this,'extensions' ) );
			add_action( 'wp_ajax_stat_extensions', array( $this,'extensions' ) );
			
		}


		public function translate() {
			load_plugin_textdomain( $this->slug, false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
		}

		public function onActivation(){
			require_once(ABSPATH .'/wp-admin/includes/plugin.php');
			$pro = "/webd-woocommerce-reporting-statistics-pro/webd-woocommerce-reporting-statistics-pro.php";
			deactivate_plugins($pro);				
		}
		
		function onDeactivation() {
		}
		
		public function BackEndScripts(){
			wp_enqueue_style( $this->plugin."adminCss", plugins_url( "/css/backend.css", __FILE__ ) );	
			wp_enqueue_style( $this->plugin."adminCss");	
			
			wp_enqueue_script('jquery');
            wp_enqueue_script( 'jquery-ui-datepicker' );
		    wp_enqueue_style( 'jquery-ui-style', plugins_url( "/css/jquery-ui.css", __FILE__ ), true);
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script("jquery-ui-tabs");			
			wp_enqueue_script( $this->plugin."charts", plugins_url( "/js/chart.js", __FILE__ ), null, true);			
			wp_enqueue_script( $this->plugin."adminJs", plugins_url( "/js/backend.js", __FILE__ ) , array('jquery','jquery-ui-accordion','jquery-ui-tabs','jquery-ui-datepicker') , null, true);	
						
			wp_enqueue_style( $this->plugin."_fa", plugins_url( '/css/font-awesome.min.css', __FILE__ ));
			
			$this->localizeBackend = array(
				'thispluginpage'=> admin_url("/admin.php?page=".$this->slug),
				'url' => admin_url( 'admin-ajax.php' ),
				'plugin_url' => plugins_url( '', __FILE__ ),
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'siteUrl'	=>	site_url(),
				'plugin_wrapper'=> $this->plugin,
			);		
			wp_localize_script($this->plugin."adminJs", $this->plugin , $this->localizeBackend );
			wp_enqueue_script( $this->plugin."adminJs");
		}

		
		public function SettingsPage(){
			add_submenu_page( 'woocommerce', $this->shortName, $this->shortName, 'manage_woocommerce', $this->slug, array($this, 'init') );	
		}
		
		public function Links($links){
			$mylinks=array();
			$mylinks[] .=  '<a href="' . admin_url( "admin.php?page=".$this->slug ) . '">Settings</a>';
			$mylinks[] .=  '<a target="_blank" href="' . $this->proUrl . '">PRO Version</a>';
			return array_merge( $links, $mylinks );
		}

		public function init(){
			print "<div class='".$this->plugin."'>";
			$this->adminHeader();
			$this->adminSettings();
			$this->adminFooter();
			print "</div>";
		}
		public function initStats(){
			print "<div class='".$this->plugin."'>";
			$this->adminHeader();
			echo "<h3>". __('Statistics',$this->plugin) ."</h3>";
			echo do_shortcode( '[adStats]' );
			
			$this->adminFooter();
			print "</div>";
		}
		
 }
 $initialize = new webdWoocommerceReportingStatistics();