<?php
/**
 * Chaty Popups for widget and contact form lead
 *
 * @author  : Premio <contact@premio.io>
 * @license : GPL2
 * */

if (defined('ABSPATH') === false) {
    exit;
}


$cta_type = "simple-view";

?>
<section class="section section2" xmlns="http://www.w3.org/1999/html">
    <?php $class = count($this->socials) > 1 ? "active" : ""; ?>

    <div class="form-horizontal grid gap-7">

        <div class="chaty-inline-title">
            <?php esc_html_e("Popup Message Design and Behavior", "chaty"); ?>
            <span class="header-tooltip">
                <span class="header-tooltip-text text-center"><?php esc_html_e('Choose between two types of pop-up designs, set pop-up text, color and set a custom behavior of the widget based on visitor interaction.', 'chaty');?></span>
                <span class="ml-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <path d="M8.00004 14.6654C11.6819 14.6654 14.6667 11.6806 14.6667 7.9987C14.6667 4.3168 11.6819 1.33203 8.00004 1.33203C4.31814 1.33203 1.33337 4.3168 1.33337 7.9987C1.33337 11.6806 4.31814 14.6654 8.00004 14.6654Z" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M8 10.6667V8" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M8 5.33203H8.00667" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>
                </span>
            </span>
        </div>
        <div class="cta-options">
            <div class="cta-option">
                <input id="cta-option-simple-view" name="cta_type" value="simple-view" type="radio" class="sr-only" checked />
                <label class="chat-icon" for="cta-option-simple-view">
                    <span class="cta-default">
                        <svg width="136" height="135" viewBox="0 0 136 135" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M0 16C0 8.45753 0 4.68629 2.34315 2.34315C4.68629 0 8.45753 0 16 0H120C127.542 0 131.314 0 133.657 2.34315C136 4.68629 136 8.45753 136 16V119C136 126.542 136 130.314 133.657 132.657C131.314 135 127.542 135 120 135H16C8.45753 135 4.68629 135 2.34315 132.657C0 130.314 0 126.542 0 119V16Z" fill="white"/> <g clip-path="url(#clip0_5493_27508)"> <path d="M112 123C118.627 123 124 117.627 124 111C124 104.373 118.627 99 112 99C105.373 99 100 104.373 100 111C100 117.627 105.373 123 112 123Z" fill="#C6D7E3"/> <path d="M113.958 108.156H107.024C106.18 108.156 105.469 108.867 105.469 109.712V114.334C105.469 115.178 106.18 115.89 107.024 115.89H112.624L114.847 118.112C114.935 118.201 114.98 118.201 115.158 118.201C115.247 118.201 115.247 118.201 115.291 118.201C115.424 118.112 115.513 117.978 115.513 117.801V109.712C115.513 108.867 114.802 108.156 113.958 108.156Z" fill="white"/> <path d="M116.27 105.844H109.337C108.492 105.844 107.781 106.555 107.781 107.399H113.959C115.248 107.399 116.27 108.422 116.27 109.71V114.866L117.115 115.71C117.203 115.799 117.248 115.799 117.426 115.799C117.515 115.799 117.515 115.799 117.559 115.799C117.692 115.71 117.781 115.577 117.781 115.399V107.399C117.826 106.555 117.115 105.844 116.27 105.844Z" fill="white"/> </g> <circle cx="112" cy="51" r="10" fill="#EAEFF2"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M115.557 47.4628C115.095 46.9977 114.545 46.629 113.94 46.3779C113.334 46.1268 112.685 45.9983 112.029 46C109.281 46 107.043 48.2372 107.042 50.9872C107.042 51.8661 107.271 52.7239 107.707 53.4806L107 56.0645L109.644 55.3706C110.375 55.7687 111.195 55.9774 112.027 55.9778H112.029C114.778 55.9778 117.016 53.7406 117.017 50.9906C117.019 50.3353 116.891 49.6861 116.64 49.0806C116.39 48.4751 116.022 47.9252 115.557 47.4628ZM112.029 55.1361H112.028C111.285 55.1362 110.556 54.9364 109.918 54.5578L109.767 54.4678L108.198 54.8795L108.616 53.35L108.518 53.1933C108.103 52.5325 107.883 51.7677 107.884 50.9872C107.885 48.7017 109.744 46.8422 112.031 46.8422C112.576 46.841 113.115 46.9478 113.618 47.1565C114.121 47.3651 114.578 47.6715 114.962 48.0578C115.348 48.4423 115.653 48.8994 115.862 49.4028C116.07 49.9062 116.176 50.4458 116.174 50.9906C116.173 53.2761 114.314 55.1361 112.029 55.1361Z" fill="#83A1B7"/> <path d="M113.457 51.6253C113.571 51.667 114.183 51.9681 114.308 52.0309C114.432 52.0931 114.516 52.1247 114.547 52.177C114.578 52.2292 114.578 52.4786 114.474 52.7697C114.371 53.0609 113.873 53.3264 113.633 53.362C113.418 53.3936 113.147 53.4075 112.848 53.3125C112.668 53.2547 112.436 53.1781 112.138 53.0497C110.888 52.5097 110.071 51.2514 110.009 51.1681L110.007 51.1659C109.939 51.0749 109.5 50.4869 109.5 49.8786C109.5 49.2653 109.822 48.9642 109.936 48.8392C109.978 48.7917 110.029 48.7534 110.086 48.7267C110.144 48.6999 110.206 48.6852 110.269 48.6836C110.348 48.6833 110.428 48.6848 110.507 48.6881C110.584 48.6914 110.687 48.6592 110.787 48.9009C110.891 49.1503 111.141 49.7636 111.172 49.8264C111.203 49.8886 111.224 49.9614 111.182 50.0447C111.141 50.1281 111.12 50.1797 111.058 50.2525C110.996 50.3253 110.927 50.4153 110.871 50.4709C110.808 50.5331 110.743 50.6003 110.816 50.7253C110.889 50.8503 111.139 51.2581 111.509 51.5886C111.986 52.0131 112.387 52.1447 112.512 52.207C112.636 52.2692 112.709 52.2592 112.782 52.1759C112.854 52.0925 113.093 51.812 113.177 51.6875C113.26 51.5631 113.343 51.5836 113.457 51.6253Z" fill="#83A1B7"/> <path d="M112 31.7647C117.523 31.7647 122 27.3205 122 21.8382C122 16.356 117.523 11.9117 112 11.9117C106.477 11.9117 102 16.356 102 21.8382C102 27.3205 106.477 31.7647 112 31.7647Z" fill="#EAEFF2"/> <path d="M113.882 17.2065H109.7C109.018 17.2073 108.363 17.4769 107.88 17.9561C107.397 18.4354 107.126 19.0852 107.125 19.7629V23.9142C107.126 24.5921 107.397 25.242 107.88 25.7213C108.363 26.2007 109.018 26.4704 109.7 26.4712H113.882C114.565 26.4705 115.22 26.2009 115.703 25.7215C116.186 25.2422 116.458 24.5922 116.458 23.9142V19.7629C116.458 19.0851 116.186 18.4352 115.703 17.956C115.22 17.4767 114.565 17.2072 113.882 17.2065V17.2065ZM115.63 23.9142C115.63 24.3742 115.445 24.8151 115.118 25.1404C114.79 25.4656 114.346 25.6485 113.882 25.6491H109.7C109.237 25.6487 108.793 25.4658 108.465 25.1405C108.137 24.8152 107.953 24.3742 107.953 23.9142V19.7629C107.953 19.3031 108.138 18.8623 108.465 18.5371C108.793 18.212 109.237 18.0291 109.7 18.0286H113.882C114.346 18.0291 114.79 18.2121 115.118 18.5373C115.445 18.8625 115.63 19.3035 115.63 19.7634V23.9147V23.9142Z" fill="#83A1B7"/> <path d="M111.795 19.4516C111.319 19.4517 110.854 19.5918 110.459 19.8541C110.064 20.1164 109.756 20.4892 109.574 20.9253C109.392 21.3615 109.344 21.8414 109.437 22.3043C109.53 22.7673 109.759 23.1926 110.095 23.5264C110.431 23.8601 110.86 24.0875 111.326 24.1796C111.792 24.2717 112.276 24.2245 112.715 24.0439C113.155 23.8633 113.53 23.5574 113.794 23.165C114.059 22.7725 114.2 22.3111 114.2 21.839C114.199 21.2061 113.946 20.5992 113.495 20.1516C113.044 19.704 112.432 19.4523 111.795 19.4516V19.4516ZM111.795 23.4039C111.483 23.4039 111.178 23.3121 110.919 23.1401C110.659 22.9681 110.457 22.7236 110.338 22.4376C110.218 22.1515 110.187 21.8368 110.248 21.5332C110.309 21.2295 110.459 20.9506 110.68 20.7317C110.9 20.5128 111.181 20.3637 111.487 20.3033C111.793 20.2429 112.11 20.2739 112.398 20.3924C112.686 20.5108 112.933 20.7115 113.106 20.9689C113.279 21.2263 113.372 21.5289 113.372 21.8385C113.371 22.2536 113.205 22.6515 112.909 22.9449C112.614 23.2384 112.213 23.4035 111.795 23.4039V23.4039Z" fill="#83A1B7"/> <path d="M114.301 18.7548C114.161 18.7549 114.025 18.8033 113.917 18.8917C113.808 18.9801 113.734 19.1031 113.707 19.2398C113.68 19.3764 113.701 19.5182 113.767 19.641C113.833 19.7638 113.94 19.8601 114.07 19.9134C114.2 19.9666 114.344 19.9737 114.478 19.9333C114.612 19.8928 114.728 19.8075 114.806 19.6917C114.884 19.5759 114.919 19.4368 114.906 19.2982C114.892 19.1596 114.83 19.03 114.731 18.9314C114.617 18.8185 114.463 18.755 114.301 18.7548V18.7548Z" fill="#83A1B7"/> <path d="M112 89.3382C117.523 89.3382 122 84.894 122 79.4118C122 73.9295 117.523 69.4853 112 69.4853C106.477 69.4853 102 73.9295 102 79.4118C102 84.894 106.477 89.3382 112 89.3382Z" fill="#EAEFF2"/> <path d="M111.024 82.0552L109.188 85.3385L113.064 83.0129L111.024 82.0552Z" fill="#83A1B7"/> <path d="M116.533 75.1451C116.465 75.0767 116.329 75.0767 116.193 75.0767L105.993 79.1807C105.857 79.2491 105.789 79.3859 105.789 79.5227C105.789 79.6596 105.857 79.7964 105.993 79.8648L114.833 83.9688C114.901 83.9688 114.901 83.9688 114.969 83.9688C115.037 83.9688 115.105 83.9688 115.105 83.9004C115.173 83.832 115.241 83.7636 115.309 83.6268L116.669 75.4187C116.669 75.3503 116.669 75.2135 116.533 75.1451Z" fill="#83A1B7"/> <path d="M116.328 75.4199L109.188 81.3024V85.3381L111.092 82.1916L116.328 75.4199Z" fill="#F2F2F2"/> <defs> <clipPath id="clip0_5493_27508"> <rect width="24" height="24" fill="white" transform="translate(100 99)"/> </clipPath> </defs> </svg>
                    </span>
                    <span class="cta-selected">
                        <svg width="136" height="136" viewBox="0 0 136 136" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M0 16C0 8.45753 0 4.68629 2.34315 2.34315C4.68629 0 8.45753 0 16 0H120C127.542 0 131.314 0 133.657 2.34315C136 4.68629 136 8.45753 136 16V120C136 127.542 136 131.314 133.657 133.657C131.314 136 127.542 136 120 136H16C8.45753 136 4.68629 136 2.34315 133.657C0 131.314 0 127.542 0 120V16Z" fill="url(#paint0_linear_5493_27214)"/> <g clip-path="url(#clip0_5493_27214)"> <path d="M112 123C118.627 123 124 117.627 124 111C124 104.373 118.627 99 112 99C105.373 99 100 104.373 100 111C100 117.627 105.373 123 112 123Z" fill="#B78DEB"/> <path d="M113.958 108.156H107.024C106.18 108.156 105.469 108.867 105.469 109.712V114.334C105.469 115.178 106.18 115.89 107.024 115.89H112.624L114.847 118.112C114.935 118.201 114.98 118.201 115.158 118.201C115.247 118.201 115.247 118.201 115.291 118.201C115.424 118.112 115.513 117.978 115.513 117.801V109.712C115.513 108.867 114.802 108.156 113.958 108.156Z" fill="white"/> <path d="M116.27 105.844H109.337C108.492 105.844 107.781 106.555 107.781 107.399H113.959C115.248 107.399 116.27 108.422 116.27 109.71V114.866L117.115 115.71C117.203 115.799 117.248 115.799 117.426 115.799C117.515 115.799 117.515 115.799 117.559 115.799C117.692 115.71 117.781 115.577 117.781 115.399V107.399C117.826 106.555 117.115 105.844 116.27 105.844Z" fill="white"/> </g> <circle cx="112" cy="51" r="10" fill="#49E670"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M115.557 47.4628C115.095 46.9977 114.545 46.629 113.94 46.3779C113.334 46.1268 112.685 45.9983 112.029 46C109.281 46 107.043 48.2372 107.042 50.9872C107.042 51.8661 107.271 52.7239 107.707 53.4806L107 56.0645L109.644 55.3706C110.375 55.7687 111.195 55.9774 112.027 55.9778H112.029C114.778 55.9778 117.016 53.7406 117.017 50.9906C117.019 50.3353 116.891 49.6861 116.64 49.0806C116.39 48.4751 116.022 47.9252 115.557 47.4628ZM112.029 55.1361H112.028C111.285 55.1362 110.556 54.9364 109.918 54.5578L109.767 54.4678L108.198 54.8795L108.616 53.35L108.518 53.1933C108.103 52.5325 107.883 51.7677 107.884 50.9872C107.885 48.7017 109.744 46.8422 112.031 46.8422C112.576 46.841 113.115 46.9478 113.618 47.1565C114.121 47.3651 114.578 47.6715 114.962 48.0578C115.348 48.4423 115.653 48.8994 115.862 49.4028C116.07 49.9062 116.176 50.4458 116.174 50.9906C116.173 53.2761 114.314 55.1361 112.029 55.1361Z" fill="white"/> <path d="M113.457 51.6253C113.571 51.667 114.183 51.9681 114.308 52.0309C114.432 52.0931 114.516 52.1247 114.547 52.177C114.578 52.2292 114.578 52.4786 114.474 52.7697C114.371 53.0609 113.873 53.3264 113.633 53.362C113.418 53.3936 113.147 53.4075 112.848 53.3125C112.668 53.2547 112.436 53.1781 112.138 53.0497C110.888 52.5097 110.071 51.2514 110.009 51.1681L110.007 51.1659C109.939 51.0749 109.5 50.4869 109.5 49.8786C109.5 49.2653 109.822 48.9642 109.936 48.8392C109.978 48.7917 110.029 48.7534 110.086 48.7267C110.144 48.6999 110.206 48.6852 110.269 48.6836C110.348 48.6833 110.428 48.6848 110.507 48.6881C110.584 48.6914 110.687 48.6592 110.787 48.9009C110.891 49.1503 111.141 49.7636 111.172 49.8264C111.203 49.8886 111.224 49.9614 111.182 50.0447C111.141 50.1281 111.12 50.1797 111.058 50.2525C110.996 50.3253 110.927 50.4153 110.871 50.4709C110.808 50.5331 110.743 50.6003 110.816 50.7253C110.889 50.8503 111.139 51.2581 111.509 51.5886C111.986 52.0131 112.387 52.1447 112.512 52.207C112.636 52.2692 112.709 52.2592 112.782 52.1759C112.854 52.0925 113.093 51.812 113.177 51.6875C113.26 51.5631 113.343 51.5836 113.457 51.6253Z" fill="white"/> <path d="M112 32C117.523 32 122 27.5228 122 22C122 16.4772 117.523 12 112 12C106.477 12 102 16.4772 102 22C102 27.5228 106.477 32 112 32Z" fill="url(#paint1_linear_5493_27214)"/> <path d="M113.882 17.334H109.7C109.018 17.3348 108.363 17.6064 107.88 18.0892C107.397 18.572 107.126 19.2266 107.125 19.9094V24.0914C107.126 24.7743 107.397 25.429 107.88 25.9119C108.363 26.3948 109.018 26.6665 109.7 26.6673H113.882C114.565 26.6666 115.22 26.395 115.703 25.9121C116.186 25.4292 116.458 24.7744 116.458 24.0914V19.9094C116.458 19.2265 116.186 18.5718 115.703 18.089C115.22 17.6062 114.565 17.3347 113.882 17.334V17.334ZM115.63 24.0914C115.63 24.5548 115.445 24.999 115.118 25.3266C114.79 25.6543 114.346 25.8386 113.882 25.8391H109.7C109.237 25.8387 108.793 25.6544 108.465 25.3268C108.137 24.9991 107.953 24.5548 107.953 24.0914V19.9094C107.953 19.4461 108.138 19.002 108.465 18.6745C108.793 18.347 109.237 18.1627 109.7 18.1622H113.882C114.346 18.1627 114.79 18.347 115.118 18.6747C115.445 19.0023 115.63 19.4465 115.63 19.9099V24.0919V24.0914Z" fill="white"/> <path d="M111.795 19.5957C111.319 19.5958 110.854 19.7369 110.459 20.0012C110.064 20.2654 109.756 20.641 109.574 21.0803C109.392 21.5197 109.344 22.0032 109.437 22.4696C109.53 22.936 109.759 23.3644 110.095 23.7006C110.431 24.0369 110.86 24.2659 111.326 24.3587C111.792 24.4515 112.276 24.4039 112.715 24.222C113.155 24.0401 113.53 23.7319 113.794 23.3366C114.059 22.9412 114.2 22.4764 114.2 22.0008C114.199 21.3632 113.946 20.7518 113.495 20.3009C113.044 19.85 112.432 19.5964 111.795 19.5957ZM111.795 23.5772C111.483 23.5772 111.178 23.4848 110.919 23.3115C110.659 23.1382 110.457 22.8919 110.338 22.6038C110.218 22.3156 110.187 21.9986 110.248 21.6927C110.309 21.3868 110.459 21.1058 110.68 20.8853C110.9 20.6647 111.181 20.5145 111.487 20.4537C111.793 20.3928 112.11 20.4241 112.398 20.5434C112.686 20.6628 112.933 20.8649 113.106 21.1242C113.279 21.3836 113.372 21.6884 113.372 22.0003C113.371 22.4184 113.205 22.8193 112.909 23.1149C112.614 23.4106 112.213 23.5768 111.795 23.5772Z" fill="white"/> <path d="M114.301 18.8937C114.161 18.8938 114.025 18.9425 113.917 19.0316C113.808 19.1207 113.734 19.2446 113.707 19.3823C113.68 19.5199 113.701 19.6628 113.767 19.7865C113.833 19.9102 113.94 20.0072 114.07 20.0609C114.2 20.1145 114.344 20.1216 114.478 20.0809C114.612 20.0402 114.728 19.9542 114.806 19.8375C114.884 19.7209 114.919 19.5808 114.906 19.4411C114.892 19.3015 114.83 19.1709 114.731 19.0716C114.617 18.9579 114.463 18.8939 114.301 18.8937Z" fill="white"/> <path d="M112 90C117.523 90 122 85.5228 122 80C122 74.4772 117.523 70 112 70C106.477 70 102 74.4772 102 80C102 85.5228 106.477 90 112 90Z" fill="#3E99D8"/> <path d="M111.024 82.6631L109.188 85.9707L113.064 83.6278L111.024 82.6631Z" fill="#E0E0E0"/> <path d="M116.533 75.7017C116.465 75.6328 116.329 75.6328 116.193 75.6328L105.993 79.7673C105.857 79.8362 105.789 79.974 105.789 80.1118C105.789 80.2497 105.857 80.3875 105.993 80.4564L114.833 84.5909C114.901 84.5909 114.901 84.5909 114.969 84.5909C115.037 84.5909 115.105 84.5909 115.105 84.5219C115.173 84.453 115.241 84.3841 115.309 84.2463L116.669 75.9774C116.669 75.9084 116.669 75.7706 116.533 75.7017Z" fill="white"/> <path d="M116.328 75.9785L109.188 81.9046V85.9702L111.092 82.8004L116.328 75.9785Z" fill="#F2F2F2"/> <defs> <linearGradient id="paint0_linear_5493_27214" x1="3" y1="4" x2="131" y2="132.5" gradientUnits="userSpaceOnUse"> <stop offset="0.19096" stop-color="#B78DEB" stop-opacity="0"/> <stop offset="1" stop-color="#B78DEB" stop-opacity="0.15"/> </linearGradient> <linearGradient id="paint1_linear_5493_27214" x1="119.84" y1="15.84" x2="104.56" y2="29" gradientUnits="userSpaceOnUse"> <stop stop-color="#4A64D5"/> <stop offset="0.322" stop-color="#9737BD"/> <stop offset="0.636" stop-color="#F15540"/> <stop offset="1" stop-color="#FECC69"/> </linearGradient> <clipPath id="clip0_5493_27214"> <rect width="24" height="24" fill="white" transform="translate(100 99)"/> </clipPath> </defs> </svg>
                    </span>
                </label>
                <label class="chat-label" for="cta-option-simple-view"><span></span> <?php esc_html_e("Simple view", "chaty"); ?></label>
            </div>
            <div class="cta-option" id="cta-option-chat-view-pro">
                <div class="pro-feature-box">
                    <div class="pro-option">
                        <input id="cta-option-chat-view" disabled name="cta_type" value="chat-view" type="radio" class="sr-only" />
                        <label class="chat-icon" for="cta-option-chat-view">
                            <span class="cta-default">
                                <svg width="136" height="136" viewBox="0 0 136 136" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M0 16C0 8.45753 0 4.68629 2.34315 2.34315C4.68629 0 8.45753 0 16 0H120C127.542 0 131.314 0 133.657 2.34315C136 4.68629 136 8.45753 136 16V120C136 127.542 136 131.314 133.657 133.657C131.314 136 127.542 136 120 136H16C8.45753 136 4.68629 136 2.34315 133.657C0 131.314 0 127.542 0 120V16Z" fill="white"/> <g clip-path="url(#clip0_5493_27235)"> <path d="M112 124C118.627 124 124 118.627 124 112C124 105.373 118.627 100 112 100C105.373 100 100 105.373 100 112C100 118.627 105.373 124 112 124Z" fill="#C6D7E3"/> <path d="M113.958 109.156H107.024C106.18 109.156 105.469 109.867 105.469 110.711V115.334C105.469 116.178 106.18 116.889 107.024 116.889H112.624L114.847 119.111C114.935 119.2 114.98 119.2 115.158 119.2C115.247 119.2 115.247 119.2 115.291 119.2C115.424 119.111 115.513 118.978 115.513 118.8V110.711C115.513 109.867 114.802 109.156 113.958 109.156Z" fill="white"/> <path d="M116.27 106.844H109.337C108.492 106.844 107.781 107.555 107.781 108.4H113.959C115.248 108.4 116.27 109.422 116.27 110.711V115.866L117.115 116.711C117.203 116.8 117.248 116.8 117.426 116.8C117.515 116.8 117.515 116.8 117.559 116.8C117.692 116.711 117.781 116.578 117.781 116.4V108.4C117.826 107.555 117.115 106.844 116.27 106.844Z" fill="white"/> </g> <rect x="12" y="12" width="112" height="83" rx="8" fill="#EAEFF2"/> <rect x="20" y="40" width="94" height="4" rx="2" fill="#C6D7E3"/> <rect opacity="0.3" x="12" y="12" width="112" height="20" fill="#C6D7E3"/> <rect x="20" y="48" width="86" height="4" rx="2" fill="#C6D7E3"/> <rect x="20" y="56" width="45" height="4" rx="2" fill="#C6D7E3"/> <path d="M117 19L111 25" stroke="#83A1B7" stroke-linecap="round" stroke-linejoin="round"/> <path d="M111 19L117 25" stroke="#83A1B7" stroke-linecap="round" stroke-linejoin="round"/> <g clip-path="url(#clip1_5493_27235)"> <path d="M71 87C74.866 87 78 83.866 78 80C78 76.134 74.866 73 71 73C67.134 73 64 76.134 64 80C64 83.866 67.134 87 71 87Z" fill="#C6D7E3"/> </g> <g clip-path="url(#clip2_5493_27235)"> <path d="M49 87C52.866 87 56 83.866 56 80C56 76.134 52.866 73 49 73C45.134 73 42 76.134 42 80C42 83.866 45.134 87 49 87Z" fill="#C6D7E3"/> </g> <g clip-path="url(#clip3_5493_27235)"> <path d="M27 87C30.866 87 34 83.866 34 80C34 76.134 30.866 73 27 73C23.134 73 20 76.134 20 80C20 83.866 23.134 87 27 87Z" fill="#C6D7E3"/> </g> <defs> <clipPath id="clip0_5493_27235"> <rect width="24" height="24" fill="white" transform="translate(100 100)"/> </clipPath> <clipPath id="clip1_5493_27235"> <rect width="14" height="14" fill="white" transform="translate(64 73)"/> </clipPath> <clipPath id="clip2_5493_27235"> <rect width="14" height="14" fill="white" transform="translate(42 73)"/> </clipPath> <clipPath id="clip3_5493_27235"> <rect width="14" height="14" fill="white" transform="translate(20 73)"/> </clipPath> </defs> </svg>
                            </span>
                            <span class="cta-selected">
                                <svg width="136" height="136" viewBox="0 0 136 136" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M0 16C0 8.45753 0 4.68629 2.34315 2.34315C4.68629 0 8.45753 0 16 0H120C127.542 0 131.314 0 133.657 2.34315C136 4.68629 136 8.45753 136 16V120C136 127.542 136 131.314 133.657 133.657C131.314 136 127.542 136 120 136H16C8.45753 136 4.68629 136 2.34315 133.657C0 131.314 0 127.542 0 120V16Z" fill="white"/> <path d="M0 16C0 8.45753 0 4.68629 2.34315 2.34315C4.68629 0 8.45753 0 16 0H120C127.542 0 131.314 0 133.657 2.34315C136 4.68629 136 8.45753 136 16V120C136 127.542 136 131.314 133.657 133.657C131.314 136 127.542 136 120 136H16C8.45753 136 4.68629 136 2.34315 133.657C0 131.314 0 127.542 0 120V16Z" fill="url(#paint0_linear_5493_27529)"/> <g clip-path="url(#clip0_5493_27529)"> <path d="M112 124C118.627 124 124 118.627 124 112C124 105.373 118.627 100 112 100C105.373 100 100 105.373 100 112C100 118.627 105.373 124 112 124Z" fill="#B78DEB"/> <path d="M113.958 109.156H107.024C106.18 109.156 105.469 109.867 105.469 110.711V115.334C105.469 116.178 106.18 116.889 107.024 116.889H112.624L114.847 119.111C114.935 119.2 114.98 119.2 115.158 119.2C115.247 119.2 115.247 119.2 115.291 119.2C115.424 119.111 115.513 118.978 115.513 118.8V110.711C115.513 109.867 114.802 109.156 113.958 109.156Z" fill="white"/> <path d="M116.27 106.844H109.337C108.492 106.844 107.781 107.555 107.781 108.4H113.959C115.248 108.4 116.27 109.422 116.27 110.711V115.866L117.115 116.711C117.203 116.8 117.248 116.8 117.426 116.8C117.515 116.8 117.515 116.8 117.559 116.8C117.692 116.711 117.781 116.578 117.781 116.4V108.4C117.826 107.555 117.115 106.844 116.27 106.844Z" fill="white"/> </g> <g filter="url(#filter0_d_5493_27529)"> <rect x="12" y="12" width="112" height="83" rx="8" fill="white"/> <rect x="20" y="40" width="94" height="4" rx="2" fill="#B78DEB" fill-opacity="0.4"/> <rect x="12" y="12" width="112" height="20" fill="#B78DEB" fill-opacity="0.2"/> <rect x="20" y="48" width="86" height="4" rx="2" fill="#B78DEB" fill-opacity="0.4"/> <rect x="20" y="56" width="45" height="4" rx="2" fill="#B78DEB" fill-opacity="0.4"/> <path d="M117 19L111 25" stroke="#83A1B7" stroke-linecap="round" stroke-linejoin="round"/> <path d="M111 19L117 25" stroke="#83A1B7" stroke-linecap="round" stroke-linejoin="round"/> <circle cx="49" cy="80" r="7" fill="#49E670"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M51.4901 77.524C51.1666 77.1984 50.7818 76.9403 50.3579 76.7645C49.9341 76.5887 49.4795 76.4988 49.0206 76.5C47.0964 76.5 45.5299 78.0661 45.5292 79.9911C45.5292 80.6063 45.6898 81.2067 45.9951 81.7364L45.5 83.5451L47.3507 83.0594C47.8627 83.3381 48.4362 83.4842 49.0191 83.4845H49.0206C50.9444 83.4845 52.5109 81.9184 52.5117 79.9934C52.513 79.5347 52.4234 79.0803 52.248 78.6564C52.0727 78.2326 51.8151 77.8477 51.4901 77.524ZM49.0206 82.8953H49.0194C48.4997 82.8953 47.9895 82.7555 47.5424 82.4905L47.4367 82.4275L46.3384 82.7156L46.6313 81.645L46.5624 81.5353C46.2719 81.0727 46.118 80.5374 46.1187 79.9911C46.1195 78.3912 47.4211 77.0896 49.0218 77.0896C49.403 77.0887 49.7806 77.1635 50.1327 77.3095C50.4848 77.4556 50.8045 77.67 51.0732 77.9405C51.3433 78.2096 51.5574 78.5296 51.7031 78.882C51.8488 79.2343 51.9233 79.6121 51.9221 79.9934C51.9213 81.5933 50.6197 82.8953 49.0206 82.8953Z" fill="white"/> <path d="M50.0197 80.4377C50.0998 80.4669 50.5283 80.6777 50.6158 80.7216C50.7026 80.7652 50.7613 80.7873 50.7831 80.8239C50.8048 80.8605 50.8048 81.0351 50.7321 81.2388C50.6594 81.4426 50.3109 81.6285 50.1433 81.6534C49.9928 81.6756 49.8027 81.6853 49.5938 81.6188C49.4674 81.5783 49.3049 81.5247 49.0964 81.4348C48.2214 81.0568 47.6498 80.176 47.6062 80.1177L47.6051 80.1162C47.5575 80.0525 47.25 79.6408 47.25 79.2151C47.25 78.7857 47.4752 78.575 47.5553 78.4875C47.5845 78.4542 47.6203 78.4274 47.6604 78.4087C47.7005 78.3899 47.744 78.3797 47.7882 78.3786C47.8438 78.3784 47.8995 78.3794 47.9551 78.3817C48.0087 78.384 48.0807 78.3615 48.1511 78.5306C48.2238 78.7052 48.3984 79.1346 48.4202 79.1785C48.4423 79.2221 48.4567 79.273 48.4276 79.3313C48.3984 79.3897 48.384 79.4258 48.3404 79.4768C48.2969 79.5277 48.2491 79.5907 48.2098 79.6296C48.1658 79.6732 48.1203 79.7202 48.1713 79.8077C48.2222 79.8952 48.3972 80.1807 48.6566 80.4121C48.9899 80.7092 49.2711 80.8013 49.3582 80.8449C49.4453 80.8885 49.4962 80.8815 49.5472 80.8231C49.5981 80.7648 49.7653 80.5684 49.8237 80.4813C49.882 80.3942 49.9399 80.4086 50.0197 80.4377Z" fill="white"/> <path d="M27 87C30.866 87 34 83.866 34 80C34 76.134 30.866 73 27 73C23.134 73 20 76.134 20 80C20 83.866 23.134 87 27 87Z" fill="url(#paint1_linear_5493_27529)"/> <path d="M28.324 76.7334H25.3965C24.9186 76.734 24.4604 76.9241 24.1224 77.262C23.7844 77.6 23.5943 78.0582 23.5938 78.5362V81.4636C23.5942 81.9416 23.7843 82.3999 24.1223 82.738C24.4602 83.076 24.9185 83.2662 25.3965 83.2667H28.324C28.802 83.2663 29.2604 83.0761 29.5984 82.7381C29.9365 82.4 30.1266 81.9417 30.1271 81.4636V78.5362C30.1265 78.0582 29.9363 77.5999 29.5983 77.2619C29.2603 76.9239 28.802 76.7339 28.324 76.7334V76.7334ZM29.5473 81.4636C29.547 81.7879 29.4179 82.0989 29.1886 82.3282C28.9593 82.5576 28.6483 82.6866 28.324 82.687H25.3965C25.0721 82.6867 24.7611 82.5577 24.5318 82.3284C24.3024 82.099 24.1734 81.788 24.1731 81.4636V78.5362C24.1736 78.2119 24.3027 77.901 24.532 77.6718C24.7613 77.4425 25.0722 77.3135 25.3965 77.3131H28.324C28.6483 77.3135 28.9593 77.4425 29.1886 77.6719C29.4179 77.9012 29.547 78.2122 29.5473 78.5365V81.464V81.4636Z" fill="white"/> <path d="M26.8547 78.3174C26.5219 78.3175 26.1965 78.4162 25.9197 78.6012C25.643 78.7862 25.4273 79.0491 25.2999 79.3566C25.1726 79.6642 25.1393 80.0026 25.2042 80.3291C25.2692 80.6556 25.4295 80.9555 25.6649 81.1908C25.9003 81.4262 26.2002 81.5865 26.5266 81.6515C26.8531 81.7164 27.1915 81.6831 27.4991 81.5558C27.8066 81.4284 28.0695 81.2127 28.2545 80.936C28.4395 80.6592 28.5383 80.3339 28.5383 80.001C28.5379 79.5546 28.3603 79.1267 28.0447 78.811C27.7291 78.4954 27.3011 78.3179 26.8547 78.3174V78.3174ZM26.8547 81.1045C26.6364 81.1045 26.423 81.0397 26.2415 80.9184C26.06 80.7971 25.9185 80.6247 25.8349 80.423C25.7514 80.2213 25.7295 79.9994 25.7721 79.7853C25.8147 79.5711 25.9198 79.3745 26.0742 79.2201C26.2286 79.0657 26.4253 78.9606 26.6394 78.918C26.8535 78.8754 27.0755 78.8972 27.2772 78.9808C27.4789 79.0643 27.6513 79.2058 27.7726 79.3873C27.8939 79.5689 27.9586 79.7823 27.9586 80.0006C27.9583 80.2933 27.8419 80.5739 27.635 80.7808C27.428 80.9878 27.1474 81.1042 26.8547 81.1045V81.1045Z" fill="white"/> <path d="M28.6118 77.8252C28.5136 77.8253 28.4184 77.8594 28.3425 77.9218C28.2667 77.9841 28.2147 78.0709 28.1956 78.1672C28.1765 78.2636 28.1914 78.3635 28.2377 78.4502C28.284 78.5368 28.3589 78.6046 28.4497 78.6422C28.5404 78.6798 28.6414 78.6848 28.7354 78.6563C28.8294 78.6277 28.9106 78.5675 28.9652 78.4859C29.0198 78.4042 29.0444 78.3062 29.0348 78.2084C29.0252 78.1107 28.982 78.0193 28.9126 77.9498C28.8328 77.8701 28.7246 77.8253 28.6118 77.8252V77.8252Z" fill="white"/> <path d="M71 87C74.866 87 78 83.866 78 80C78 76.134 74.866 73 71 73C67.134 73 64 76.134 64 80C64 83.866 67.134 87 71 87Z" fill="#3E99D8"/> <path d="M70.3165 81.8641L69.0312 84.1794L71.7445 82.5394L70.3165 81.8641Z" fill="#E0E0E0"/> <path d="M74.1694 76.9916C74.1218 76.9434 74.0266 76.9434 73.9314 76.9434L66.7912 79.8375C66.696 79.8857 66.6484 79.9822 66.6484 80.0787C66.6484 80.1751 66.696 80.2716 66.7912 80.3199L72.9793 83.214C73.027 83.214 73.027 83.214 73.0746 83.214C73.1222 83.214 73.1698 83.214 73.1698 83.1657C73.2174 83.1175 73.265 83.0693 73.3126 82.9728L74.2646 77.1845C74.2646 77.1363 74.2646 77.0398 74.1694 76.9916Z" fill="white"/> <path d="M74.0294 77.1846L69.0312 81.3328V84.1787L70.3641 81.9599L74.0294 77.1846Z" fill="#F2F2F2"/> </g> <defs> <filter id="filter0_d_5493_27529" x="8" y="10" width="120" height="91" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="2"/> <feGaussianBlur stdDeviation="2"/> <feComposite in2="hardAlpha" operator="out"/> <feColorMatrix type="matrix" values="0 0 0 0 0.513611 0 0 0 0 0.631773 0 0 0 0 0.716667 0 0 0 0.2 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_5493_27529"/> <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_5493_27529" result="shape"/> </filter> <linearGradient id="paint0_linear_5493_27529" x1="3" y1="4" x2="131" y2="132.5" gradientUnits="userSpaceOnUse"> <stop offset="0.19096" stop-color="#B78DEB" stop-opacity="0"/> <stop offset="1" stop-color="#B78DEB" stop-opacity="0.15"/> </linearGradient> <linearGradient id="paint1_linear_5493_27529" x1="32.488" y1="75.688" x2="21.792" y2="84.9" gradientUnits="userSpaceOnUse"> <stop stop-color="#4A64D5"/> <stop offset="0.322" stop-color="#9737BD"/> <stop offset="0.636" stop-color="#F15540"/> <stop offset="1" stop-color="#FECC69"/> </linearGradient> <clipPath id="clip0_5493_27529"> <rect width="24" height="24" fill="white" transform="translate(100 100)"/> </clipPath> </defs> </svg>
                            </span>
                        </label>
                        <label class="chat-label" for="cta-option-chat-view"><span></span> <?php esc_html_e("Chat view (Pro)", "chaty"); ?></label>
                    </div>
                    <a href="javascript:;" class="upgrade-btn"><?php esc_html_e("Upgrade to Pro", "chaty"); ?></a>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item widget-icon__block chaty-widget-icon o-channel <?php echo esc_attr($class) ?>">
            <label class="form-horizontal__item-label text-cht-gray-150 font-primary block text-base mb-3"><?php esc_html_e('Widget icon', 'chaty');?></label>
            <?php
            $proClass   = "has-free";
            $widgetIcon = get_option('widget_icon');
            $disabled = "disabled";
            ?>
            <div class="widget-icon__wrap space-x-4 sm:space-x-7 pb-5 items-center inline-flex <?php echo esc_attr($proClass)  ?>">

                <label class="custom-control custom-radio relative">
                    <input type="radio" name="widget_icon" class="custom-control-input js-widget-i " value="chat-base" data-type="chat-base" data-gramm_editor="false" <?php checked($widgetIcon, "chat-base") ?> />
                    <i class="icon-chat" data-type="chat-base">
                        <svg version="1.1" id="ch" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-496 507.7 54 54"style="enable-background:new -496 507.7 54 54;" xml:space="preserve">
                            <style type="text/css">.st1 { fill: #FFFFFF; }.st0 { fill: #808080; }</style>
                            <g><circle cx="-469" cy="534.7" r="27" fill="#a886cd"/></g>
                            <path class="st1" d="M-459.9,523.7h-20.3c-1.9,0-3.4,1.5-3.4,3.4v15.3c0,1.9,1.5,3.4,3.4,3.4h11.4l5.9,4.9c0.2,0.2,0.3,0.2,0.5,0.2 h0.3c0.3-0.2,0.5-0.5,0.5-0.8v-4.2h1.7c1.9,0,3.4-1.5,3.4-3.4v-15.3C-456.5,525.2-458,523.7-459.9,523.7z"/>
                            <path class="st0" d="M-477.7,530.5h11.9c0.5,0,0.8,0.4,0.8,0.8l0,0c0,0.5-0.4,0.8-0.8,0.8h-11.9c-0.5,0-0.8-0.4-0.8-0.8l0,0C-478.6,530.8-478.2,530.5-477.7,530.5z"/>
                            <path class="st0" d="M-477.7,533.5h7.9c0.5,0,0.8,0.4,0.8,0.8l0,0c0,0.5-0.4,0.8-0.8,0.8h-7.9c-0.5,0-0.8-0.4-0.8-0.8l0,0C-478.6,533.9-478.2,533.5-477.7,533.5z"/>
                        </svg>
                    </i>
                    <span class="custom-control-radio"></span>
                </label>

                <label class="custom-control custom-radio relative">
                    <input type="radio" name="widget_icon" class="custom-control-input js-widget-i" value="chat-smile" data-type="chat-smile" data-gramm_editor="false" <?php checked($widgetIcon, "chat-smile") ?>  >
                    <i class="icon-chat" data-type="chat-smile">
                        <svg version="1.1" id="smile" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-496.8 507.1 54 54" style="enable-background:new -496.8 507.1 54 54;" xml:space="preserve">
                            <style type="text/css">.st1 { fill: #FFFFFF; }.st2 { fill: none; stroke: #808080; stroke-width: 1.5; stroke-linecap: round; stroke-linejoin: round; }</style>
                            <g><circle cx="-469.8" cy="534.1" r="27" fill="#a886cd"/></g>
                            <path class="st1" d="M-459.5,523.5H-482c-2.1,0-3.7,1.7-3.7,3.7v13.1c0,2.1,1.7,3.7,3.7,3.7h19.3l5.4,5.4c0.2,0.2,0.4,0.2,0.7,0.2c0.2,0,0.2,0,0.4,0c0.4-0.2,0.6-0.6,0.6-0.9v-21.5C-455.8,525.2-457.5,523.5-459.5,523.5z"/>
                            <path class="st2" d="M-476.5,537.3c2.5,1.1,8.5,2.1,13-2.7"/>
                            <path class="st2" d="M-460.8,534.5c-0.1-1.2-0.8-3.4-3.3-2.8"/>
                        </svg>
                    </i>
                    <span class="custom-control-radio"></span>
                </label>

                <label class="custom-control custom-radio relative">
                    <input type="radio" name="widget_icon" class="custom-control-input js-widget-i" value="chat-bubble" data-type="chat-bubble" data-gramm_editor="false" <?php checked($widgetIcon, "chat-bubble") ?> />
                    <i class="icon-chat" data-type="chat-bubble">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-496.9 507.1 54 54" style="enable-background:new -496.9 507.1 54 54;" xml:space="preserve">
                            <style type="text/css">.st1 { fill: #FFFFFF; }</style>
                            <g><circle cx="-469.9" cy="534.1" r="27" fill="#a886cd"/></g>
                            <path class="st1" d="M-472.6,522.1h5.3c3,0,6,1.2,8.1,3.4c2.1,2.1,3.4,5.1,3.4,8.1c0,6-4.6,11-10.6,11.5v4.4c0,0.4-0.2,0.7-0.5,0.9 c-0.2,0-0.2,0-0.4,0c-0.2,0-0.5-0.2-0.7-0.4l-4.6-5c-3,0-6-1.2-8.1-3.4s-3.4-5.1-3.4-8.1C-484.1,527.2-478.9,522.1-472.6,522.1z M-462.9,535.3c1.1,0,1.8-0.7,1.8-1.8c0-1.1-0.7-1.8-1.8-1.8c-1.1,0-1.8,0.7-1.8,1.8C-464.6,534.6-463.9,535.3-462.9,535.3z M-469.9,535.3c1.1,0,1.8-0.7,1.8-1.8c0-1.1-0.7-1.8-1.8-1.8c-1.1,0-1.8,0.7-1.8,1.8C-471.7,534.6-471,535.3-469.9,535.3z M-477,535.3c1.1,0,1.8-0.7,1.8-1.8c0-1.1-0.7-1.8-1.8-1.8c-1.1,0-1.8,0.7-1.8,1.8C-478.8,534.6-478.1,535.3-477,535.3z"/>
                        </svg>
                    </i>
                    <span class="custom-control-radio"></span>
                </label>

                <label class="custom-control custom-radio relative add-border">
                    <input type="radio" name="widget_icon" class="custom-control-input js-widget-i" value="chat-db" data-type="chat-db" data-gramm_editor="false" <?php checked($widgetIcon, "chat-db") ?> />
                    <i class="icon-chat" data-type="chat-db">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-496 507.1 54 54" style="enable-background:new -496 507.1 54 54;" xml:space="preserve">
                            <style type="text/css">.st1 {fill: #FFFFFF;}</style>
                            <g><circle cx="-469" cy="534.1" r="27" fill="#a886cd"/></g>
                            <path class="st1" d="M-464.6,527.7h-15.6c-1.9,0-3.5,1.6-3.5,3.5v10.4c0,1.9,1.6,3.5,3.5,3.5h12.6l5,5c0.2,0.2,0.3,0.2,0.7,0.2 c0.2,0,0.2,0,0.3,0c0.3-0.2,0.5-0.5,0.5-0.9v-18.2C-461.1,529.3-462.7,527.7-464.6,527.7z"/>
                            <path class="st1" d="M-459.4,522.5H-475c-1.9,0-3.5,1.6-3.5,3.5h13.9c2.9,0,5.2,2.3,5.2,5.2v11.6l1.9,1.9c0.2,0.2,0.3,0.2,0.7,0.2 c0.2,0,0.2,0,0.3,0c0.3-0.2,0.5-0.5,0.5-0.9v-18C-455.9,524.1-457.5,522.5-459.4,522.5z"/>
                        </svg>
                    </i>
                    <span class="custom-control-radio"></span>
                </label>

                <div class="custom-control group custom-radio relative upgrade-upload-btn">
                    <div class="form-group" id="image-upload">
                        <div id="elPreviewImage"></div>
                        <i class='icon-upload'></i>
                        <div class="file-loading">
                            <input type="file" id="testUpload" name="cht_widget_img" disabled >
                        </div>
                        <div id="errorBlock" class="help-block"></div>
                    </div>
                    <span class="custom-control-radio"></span>
                    <a class="opacity-0 group-hover:opacity-100 hidden group-hover:inline-block absolute right-0 -bottom-8 w-[170px] text-center px-2 py-1.5 bg-cht-primary rounded-[4px] text-white hover:text-white focus:text-white text-base" target="_blank" href="<?php echo esc_url($this->getUpgradeMenuItemUrl()); ?>">
                        <?php esc_html_e('Upgrade to Pro', 'chaty'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item">
            <label class="align-top form-horizontal__item-label font-primary text-cht-gray-150 text-base mb-2 block"><?php esc_html_e("Position", "chaty") ?>:</label>
            <div class="tab-tab-select bg-cht-gray-50 flex-wrap gap-2 inline-flex items-center rounded-md p-1">
                <?php
                $position = get_option('cht_position');
                $position = ($position != "left" && $position != "right") ? "right" : $position;
                ?>
                <label class="custom-control custom-radio" for="left-position">
                    <input type="radio" id="left-position" name="cht_position" class="custom-control-input" <?php checked($position, "left") ?> value="left" />
                    <span class="custom-control-label"><?php esc_html_e('Left', 'chaty'); ?></span>
                </label>

                <label class="custom-control custom-radio" for="right-position">
                    <input type="radio" id="right-position" name="cht_position" class="custom-control-input" <?php checked($position, "right") ?> value="right" />
                    <span class="custom-control-label"><?php esc_html_e('Right', 'chaty'); ?></span>
                </label>

                <span class="custom-control group relative custom-radio free-custom-radio">
                    <input type="radio" class="custom-control-input" disabled>
                    <span class="custom-control-label pointer-events-none"><?php esc_html_e('Custom Position', 'chaty'); ?> </span>
                    <a class="absolute opacity-0 block z-40 group-hover:opacity-100 hover:text-white left-0 top-0 h-full py-[3px] text-base w-full text-center text-white rounded-[3px] bg-cht-primary" target="_blank" href="<?php echo esc_url($this->getUpgradeMenuItemUrl()); ?>">
                        (<?php esc_html_e('Upgrade to Pro', 'chaty'); ?>)
                    </a>
                </span>
            </div>
        </div>

        <div class="form-horizontal__item flex-center chaty-default-state single-channel-setting active">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base block mb-3"><?php esc_html_e('Default state', 'chaty');?>:</label>
            <div>
                <?php
                $states = [
                    "click" => esc_html__("Click to open", "chaty"),
                    "hover" => esc_html__("Hover to open", "chaty"),
                    "open"  => esc_html__("Opened by default", "chaty"),
                ];
                $state  = get_option('chaty_default_state');
                $state  = empty($state) ? "click" : $state;
                ?>
                <select name="chaty_default_state" id="chaty_default_state" class="chaty-select">
                    <?php foreach ($states as $key => $value) : ?>
                        <option value="<?php echo esc_attr($key); ?>" <?php selected($state, $key); ?>><?php echo esc_attr($value); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="form-horizontal__item flex-center hide-show-button <?php echo esc_attr($state == "open" ? "active" : "") ?>">
            <input type="hidden" name="cht_close_button" value="no" >
            <label class="form-horizontal__item-label text-cht-gray-150 font-primary text-base mb-2 block" for="cht_close_button"><?php esc_html_e('Show close button', 'chaty');?>:</label>
            <div>
                <label class="switch group inline-flex">
                    <?php $closeButton = get_option('cht_close_button'); ?>
                    <?php $closeButton = empty($closeButton) ? "yes" : $closeButton; ?>
                    <input data-gramm_editor="false" type="checkbox" id="cht_close_button" name="cht_close_button" value="yes" <?php checked($closeButton, "yes") ?>  >
                    <span class="chaty-slider round"></span>
                </label>
            </div>
        </div>

        <?php
        $color = $this->get_current_color();
        $color = empty($color) ? '#A886CD' : $color;
        ?>
        <div class="form-horizontal__item chaty-widget-color o-channel <?php echo esc_attr($class) ?>">
            <label class="align-top form-horizontal__item-label font-primary text-cht-gray-150 text-base mb-2 block"><?php esc_html_e('Widget icon color', 'chaty'); ?>:</label>
            <div>
                <div class="color-picker-dropdown inline-block">
                    <div class="color-picker-box">
                        <div class="color-picker-radio">
                            <label style="background-color: #A886CD">
                                <input type="checkbox" name="cht_color" value="#A886CD" title="Purple" <?php checked($color, '#A886CD') ?> >
                                <span></span>
                            </label>

                            <label style="background-color: #86CD91">
                                <input type="checkbox" name="cht_color" value="#86CD91" title="Green" <?php checked($color, '#86CD91') ?>  />
                                <span></span>
                            </label>

                            <label style="background-color: #4F6ACA">
                                <input type="checkbox" name="cht_color" value="#4F6ACA" title="Blue" <?php checked($color, '#4F6ACA') ?> />
                                <span></span>
                            </label>

                            <label style="background-color: #FF6060">
                                <input type="checkbox" name="cht_color" value="#FF6060" title="Red" <?php checked($color, '#FF6060') ?>  >
                                <span></span>
                            </label>

                            <label style="background-color: #000">
                                <input type="checkbox" name="cht_color" value="#000" title="Black" <?php checked($color, '#000') ?>  >
                                <span></span>
                            </label>

                            <label style="background-color: #EEF075">
                                <input type="checkbox" name="cht_color" value="#EEF075" title="Yellow" <?php checked($color, '#EEF075') ?>  >
                                <span></span>
                            </label>

                            <label style="background-color: #FF95EE">
                                <input type="checkbox" name="cht_color" value="#FF95EE" title="Pink" <?php checked($color, '#FF95EE') ?> >
                                <span></span>
                            </label>
                        </div>

                        <div class="color-picker-custom">
                            <div>
                                <div class="circle">?</div>
                                <span class="text-cht-gray-150 font-primary text-base"><?php esc_html_e('Custom color', 'chaty'); ?></span>
                                <a class="text-cht-primary hover:text-cht-primary hover:underline font-primary text-base" target="_blank" href="<?php echo esc_url($this->getUpgradeMenuItemUrl()); ?>">
                                    (<?php esc_html_e('Upgrade to Pro', 'chaty'); ?>)
                                </a>
                            </div>
                            <div>
                                <input type="input" name="cht_custom_colo" placeholder="HEX code: #ffffff" value="" readonly style="cursor:not-allowed;width: 227px;" />
                                <button class="btn ml-2 py-2 px-5 rounded-sm"><?php esc_html_e('Ok', 'chaty'); ?></button>
                            </div>
                        </div>
                        <?php $color = $this->get_current_color(); ?>
                        <button class="color-picker-btn-close text-cht-gray-150">
                            <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M0 0L4.31505 3.77708L8.63008 0" transform="translate(1.37436 1.31006)" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M0 0L4.31505 3.77708L8.63008 0" transform="translate(1.37436 1.31006)" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>

                    <button class="color-picker-btn text-cht-gray-150">
                        <?php $color = !empty($color) ? $color : '#A886CD'; ?>
                        <span class="circle" style="background-color: <?php echo esc_attr($color) ?>"></span>
                        <span class="text">
                            <?php
                            if (!empty($color)) {
                                $colors = $this->colors;
                                if (isset($colors[$color])) {
                                    echo esc_attr($colors[$color]);
                                } else {
                                    esc_html_e('Custom', 'chaty');
                                }
                            } else {
                                esc_html_e('Purple', 'chaty');
                            }
                            ?>
                        </span>
                        <i class="cht-arrow-icon"></i>
                    </button>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base mb-2 inline-block"><?php esc_html_e('Widget size', 'chaty') ?>:</label>
            <div class="flex items-center space-x-2">
                <?php
                $size = get_option('cht_widget_size');
                $size = empty($size) ? 54 : $size;
                $fixedSizes = ["44", "54", "70", "84", "94"];
                ?>
                <!-- custom widget size start -->
                <div class="tab-tab-select bg-cht-gray-50 rounded-md p-1 flex-wrap gap-1 inline-flex items-center">
                    <label class="custom-control custom-radio" for="size-s">
                        <input type="radio" id="size-s" class="custom-control-input widget-size-control" <?php checked($size, "44") ?> value="44" />
                        <span class="custom-control-label"><?php esc_html_e('S', 'chaty') ?></span>
                    </label>
                    <label class="custom-control custom-radio" for="size-m">
                        <input type="radio" id="size-m" class="custom-control-input widget-size-control" <?php checked($size, "54") ?> value="54" />
                        <span class="custom-control-label"><?php esc_html_e('M', 'chaty') ?></span>
                    </label>
                    <label class="custom-control custom-radio" for="size-l">
                        <input type="radio" id="size-l" class="custom-control-input widget-size-control" <?php checked($size, "70") ?> value="70" />
                        <span class="custom-control-label"><?php esc_html_e('L', 'chaty') ?></span>
                    </label>
                    <label class="custom-control custom-radio" for="size-xl">
                        <input type="radio" id="size-xl" class="custom-control-input widget-size-control" <?php checked($size, "84") ?> value="84" />
                        <span class="custom-control-label"><?php esc_html_e('XL', 'chaty') ?></span>
                    </label>
                    <label class="custom-control custom-radio" for="size-xxl">
                        <input type="radio" id="size-xxl" class="custom-control-input widget-size-control" <?php checked($size, "94") ?> value="94" />
                        <span class="custom-control-label"><?php esc_html_e('XXL', 'chaty') ?></span>
                    </label>
                    <label class="custom-control custom-radio" for="size-custom">
                        <input type="radio" id="size-custom" class="custom-control-input widget-size-control" value="<?php echo esc_attr($size) ?>" <?php echo in_array($size, $fixedSizes) ? '': 'checked' ?> >
                        <span class="custom-control-label"><?php esc_html_e('Custom', 'chaty') ?></span>
                    </label>
                </div>
                <!-- custom widget size ends -->
            </div>
            <div id="custom-widget-size" class="max-w-[410px]" style="display: <?php echo in_array($size, $fixedSizes) ? 'none' : 'block' ?>" >
                <div class="position-pro">
                    <div class="text-cht-gray-150/70">
                        <label class="text-base text-cht-gray-150/70"><?php esc_html_e('Custom widget size', 'chaty') ?>:</label>
                        <input type="number" min="0" max="2000" class="widget-size-control" value="<?php echo esc_attr($size) ?>" placeholder="<?php echo esc_attr($size) ?>">px
                    </div>
                </div>
            </div>
            <input id="custom-widget-size-input" name="cht_widget_size" type="hidden" value="<?php echo esc_attr($size) ?>"/>
        </div>

        <div class="form-horizontal__item cht-option-settings" >
            <label class="align-top form-horizontal__item-label font-primary text-cht-gray-150 text-base block mb-3"><?php esc_html_e('Call to action', 'chaty'); ?>:</label>
            <div class="disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Call to action" feature doesn\'t apply because the Chaty widget is already open.', 'chaty') ?>'>
                <?php
                $cta = get_option('cht_cta');
                ?>
                <textarea data-value="<?php echo esc_attr($cta) ?>" class="test_textarea titleColor rounded-lg text-cht-gray-150 text-base font-primary" cols="40" rows="2" name="cht_cta" placeholder="<?php esc_html_e('Message us!', 'chaty'); ?>" ><?php echo esc_attr((wp_unslash($cta))) ?></textarea>
            </div>
        </div>

        <div class="form-horizontal__item flex-center">
            <label class="align-top form-horizontal__item-label font-primary text-cht-gray-150 text-base block mb-2">
                <?php esc_html_e('Call to action behavior', 'chaty'); ?>:
                <span class="header-tooltip">
                    <span class="header-tooltip-text text-center"><?php esc_html_e('Choose how the CTA button would appear. &quot;Hide after first click&quot; hides the CTA button after the first visit. If you select the second option, the CTA stays visible all the time', "chaty") ?></span>
                    <span class="ml-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8.00004 14.6654C11.6819 14.6654 14.6667 11.6806 14.6667 7.9987C14.6667 4.3168 11.6819 1.33203 8.00004 1.33203C4.31814 1.33203 1.33337 4.3168 1.33337 7.9987C1.33337 11.6806 4.31814 14.6654 8.00004 14.6654Z" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M8 10.6667V8" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M8 5.33203H8.00667" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                    </span>
                </span>
            </label>
            <div class="cta-action-radio tab-tab-select bg-cht-gray-50 inline-block rounded-md p-1">
                <?php
                $ctaAction = get_option('cht_cta_action');
                $ctaAction = empty($ctaAction) ? "click" : $ctaAction;
                ?>
                <div class=" disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Show call to action" feature doesn\'t apply because the Chaty widget is already open.','chaty') ?>' for="all_time-cht_cta_action">
                    <label class="custom-control custom-radio">
                        <input type="radio" id="click-cht_cta_action" name="cht_cta_action" class="custom-control-input" <?php checked($ctaAction, "click") ?> value="click" />
                        <span class="custom-control-label"><?php esc_html_e('Hide after first click', 'chaty'); ?></span>
                    </label>
                </div>
                <div class=" disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Show call to action" feature doesn\'t apply because the Chaty widget is already open.','chaty') ?>' for="all_time-cht_cta_action">
                    <label class="custom-control custom-radio">
                        <input type="radio" id="all_time-cht_cta_action" name="cht_cta_action" class="custom-control-input" <?php checked($ctaAction, "all_time") ?> value="all_time" />
                        <span class="custom-control-label"><?php esc_html_e('Show all the time', 'chaty'); ?></span>
                    </label>
                </div>
            </div>
        </div>

        <div class="color-setting">
            <div class="color-box flex flex-wrap gap-5 sm:gap-8">
                <div>
                    <?php
                    $val = get_option("cht_cta_text_color");
                    $val = ($val === false) ? "#333333" : $val;
                    ?>
                    <div class="form-horizontal__item flex items-center gap-2 flex-center">
                        <label class="form-horizontal__item-label font-primary text-base text-cht-gray-150 block"><?php esc_html_e('Call to action text color', 'chaty');?>:</label>
                        <div class="disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Attention effect" feature doesn\'t apply because the Chaty widget is already open.', 'chaty') ?>'>
                            <input value="<?php echo esc_attr($val) ?>" type="text" class="chaty-color-field" name="cht_cta_text_color" id="cht_cta_text_color">
                        </div>
                    </div>
                </div>
                <div>
                    <?php
                    $val = get_option("cht_cta_bg_color");
                    $val = ($val === false) ? "#ffffff" : $val;
                    ?>
                    <div class="form-horizontal__item flex items-center gap-2 flex-center">
                        <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base block"><?php esc_html_e('Call to action background', 'chaty');?>:</label>
                        <div class="disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Attention effect" feature doesn\'t apply because the Chaty widget is already open.', 'chaty') ?>'>
                            <input value="<?php echo esc_attr($val) ?>" type="text" class="chaty-color-field" name="cht_cta_bg_color" id="cht_cta_bg_color">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item flex-center">
            <input type="hidden" name="cht_google_analytics" value="0" >
            <label class="form-horizontal__item-label text-cht-gray-150 font-primary text-base mb-2 block"><?php esc_html_e('Google Analytics', 'chaty');?>:</label>
            <div>
                <label class="switch group inline-flex">
                    <?php
                    $checked = get_option('cht_google_analytics');
                    ?>
                    <input data-gramm_editor="false" type="checkbox" name="cht_google_analytics" value="1" <?php checked($checked, 1) ?> <?php echo esc_attr($disabled) ?> >
                    <span class="chaty-slider round"></span>
                    <a target="_blank" class="opacity-0 px-5 py-1.5 group-hover:opacity-100 ml-4 pro-btn bg-cht-primary rounded-[6px] text-white hover:text-white" href="<?php echo esc_url($this->getUpgradeMenuItemUrl()); ?>">
                        <?php esc_html_e('Upgrade to Pro', 'chaty'); ?>
                    </a>
                </label>
            </div>
        </div>

        <div class="form-horizontal__item chaty-icon-view active chaty-chat-view-option">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base block mb-3" for="chaty_icons_view"><?php esc_html_e('Icons view', 'chaty');?>:</label>
            <div>
                <?php
                $mode  = get_option('chaty_icons_view');
                $mode  = empty($mode) ? "vertical" : $mode;
                ?>
                <div class="tab-tab-select bg-cht-gray-50 inline-block rounded-md p-1">
                    <label class="custom-control custom-radio" for="vertical-position">
                        <input type="radio" id="vertical-position" name="chaty_icons_view" class="custom-control-input" <?php checked($mode, "vertical") ?> value="vertical" />
                        <span class="custom-control-label"><?php esc_html_e('Vertical', 'chaty'); ?></span>
                    </label>

                    <label class="custom-control custom-radio" for="horizontal-position">
                        <input type="radio" id="horizontal-position" name="chaty_icons_view" class="custom-control-input" <?php checked($mode, "horizontal") ?> value="horizontal" />
                        <span class="custom-control-label"><?php esc_html_e('Horizontal', 'chaty'); ?></span>
                    </label>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item flex-center">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base mb-3 block">
                <?php esc_html_e('Attention effect', 'chaty');?>:
                <span class="header-tooltip">
                    <span class="header-tooltip-text text-center"><?php esc_html_e('The attention effect will appear on your site until your website visitors engage with the widget for the first time. After the first engagement, the attention effect will not appear again.','chaty') ?></span>
                    <span class="ml-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8.00004 14.6654C11.6819 14.6654 14.6667 11.6806 14.6667 7.9987C14.6667 4.3168 11.6819 1.33203 8.00004 1.33203C4.31814 1.33203 1.33337 4.3168 1.33337 7.9987C1.33337 11.6806 4.31814 14.6654 8.00004 14.6654Z" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M8 10.6667V8" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M8 5.33203H8.00667" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                    </span>
                </span>
            </label>
            <div class="disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Attention effect" feature doesn\'t apply because the Chaty widget is already open.','chaty') ?>'>
                <?php
                $group   = '';
                $effects = [
                    ""           => "None",
                    "jump"       => "Bounce",
                    "waggle"     => "Waggle",
                    "sheen"      => "Sheen",
                    "spin"       => "Spin",
                    "fade"       => "Fade",
                    "shockwave"  => "Shockwave",
                    "blink"      => "Blink",
                    "pulse-icon" => "Pulse",
                ];
                $effect  = get_option('chaty_attention_effect');
                $effect  = empty($effect) ? "" : $effect;
                ?>
                <select name="chaty_attention_effect" class="chaty-select" id="chaty_attention_effect" data-effect="<?php echo esc_attr($effect) ?>">
                    <?php foreach ($effects as $key => $value) : ?>
                        <option value="<?php echo esc_attr($key); ?>" <?php selected($effect, $key); ?>><?php echo esc_attr($value); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="form-horizontal__item flex-center">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 block text-base mb-3">
                <?php esc_html_e('Pending messages', 'chaty');?>:
                <span class="icon label-tooltip" data-label="<?php esc_html_e("Increase your click-rate by displaying a pending messages icon near your Chaty widget to let your visitors know that you\"re waiting for them to contact you.", 'chaty') ?>">
                <span class="ml-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                        <path d="M8.00004 14.6654C11.6819 14.6654 14.6667 11.6806 14.6667 7.9987C14.6667 4.3168 11.6819 1.33203 8.00004 1.33203C4.31814 1.33203 1.33337 4.3168 1.33337 7.9987C1.33337 11.6806 4.31814 14.6654 8.00004 14.6654Z" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M8 10.6667V8" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M8 5.33203H8.00667" stroke="#72777c" stroke-width="1.33" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>
                </span>
                </span> 
            </label>
            <div class="disable-message" data-label='<?php esc_html_e('When the default state is set to "Opened by default", the "Pending messages" feature doesn\'t apply because the Chaty widget is already open.', 'chaty') ?>'>
                <label class="switch">
                    <?php
                    $checked     = get_option('cht_pending_messages');
                    $checked     = empty($checked) ? "off" : $checked;
                    $activeClass = ($checked == "on") ? "active" : "";
                    ?>
                    <input type="hidden" name="cht_pending_messages" value="off">
                    <input type="checkbox" id="cht_pending_messages" name="cht_pending_messages" value="on" <?php checked($checked, "on") ?> >
                    <span class="chaty-slider round"></span>
                </label>
            </div>
        </div>

        <div class="form-horizontal__item flex-center pending-message-items <?php echo esc_attr($activeClass) ?>">
            <div class="group-control-wrap p-3 space-y-2 relative -top-3 max-w-[410px]">
                <?php
                $val = get_option("cht_number_of_messages");
                $val = ($val === false || empty($val)) ? "1" : $val;
                ?>
                <div class="form-horizontal__item float-left flex pending-message-items items-center gap-2 <?php echo esc_attr($activeClass) ?>">
                    <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base"><?php esc_html_e('Number of messages', 'chaty');?>:</label>
                    <div>
                        <input value="<?php echo esc_attr($val) ?>" style="border-color:#eaeff2" min="0" type="number" class="cht-input w-16 border border-solid text-center hover:border-cht-primary text-cht-gray-150 px-[0_!important]" name="cht_number_of_messages" id="cht_number_of_messages">
                    </div>
                </div>
                <div class="clear-both"></div>
                <?php
                $val = get_option("cht_number_color");
                $val = ($val === false || empty($val)) ? "#ffffff" : $val;
                ?>
                <div class="form-horizontal__item flex pending-message-items mr-4 float-left items-center gap-2 <?php echo esc_attr($activeClass) ?>">
                    <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base"><?php esc_html_e('Number color', 'chaty');?>:</label>
                    <div>
                        <input value="<?php echo esc_attr($val) ?>" type="text" class="chaty-color-field w-16" name="cht_number_color" id="cht_number_color">
                    </div>
                </div>

                <?php
                $val = get_option("cht_number_bg_color");
                $val = ($val === false || empty($val)) ? "#dd0000" : $val;
                ?>
                <div class="form-horizontal__item flex pending-message-items float-left items-center gap-2 <?php echo esc_attr($activeClass) ?>">
                    <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base"><?php esc_html_e('Background color', 'chaty');?>:</label>
                    <div>
                        <input value="<?php echo esc_attr($val) ?>" type="text" class="chaty-color-field w-16" name="cht_number_bg_color" id="cht_number_bg_color">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-horizontal__item font-section">
            <label class="form-horizontal__item-label font-primary text-cht-gray-150 text-base block mb-2"><?php esc_html_e('Font Family', 'chaty');?>:</label>
            <div>
                <?php
                $font = get_option('cht_widget_font');
                $font = ($font === false)?"System Stack":$font;
                ?>
                <select name="cht_widget_font" class="form-fonts" id="cht_widget_font">
                    <option value="">Select font family</option>
                    <?php $group = '';
                    foreach ($fonts as $key => $value):
                        if ($value != $group) {
                            echo '<optgroup label="' . $value . '">';
                            $group = $value;
                        }
                        $key_value = $key;
                        if($key == "-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Oxygen-Sans,Ubuntu,Cantarell,'Helvetica Neue',sans-serif") {
                            $key_value = 'system_font';
                        }
                        ?>
                        <option data-group="<?php echo esc_attr($value); ?>" value="<?php echo esc_attr($key_value); ?>" data-type="<?php echo esc_attr($value); ?>" <?php selected($font, $key_value); ?>><?php echo esc_attr($key); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <input type="hidden" id="chaty_site_url" value="<?php echo site_url("/") ?>" >
        <?php $requestData = filter_input_array(INPUT_GET); ?>
        <?php if (isset($requestData['page']) && $requestData['page'] == "chaty-widget-settings") { ?>
            <input type="hidden" name="widget" value="new-widget" >
        <?php } else if (isset($requestData['widget']) && !empty($requestData['widget']) && is_numeric($requestData['widget']) && $requestData['widget'] > 0) { ?>
            <input type="hidden" name="widget" value="<?php echo esc_attr($requestData['widget']) ?>" >
        <?php } ?>
    </div>

</section>
<div id="custom-css"></div>
