<?php
/* Custom functions code goes here. */

add_filter('woocommerce_email_subject_new_order', 'change_admin_email_subject', 10, 2);

/* Función para saber si el rol del usuario que ha realizado la compra es
profesional o particular */
function change_admin_email_subject( $subject, $order ) {

	// Obtenemos la ficha del usuario por medio del ID del usuario que ha realizado el pedido
	$usuario = get_user_by('id', $order->get_user_id());
	$rol_usuario = '';

	// Comprobamos si se han recuperado datos
	if ( ! empty( $usuario ) ) {
		$roles_usuario = ( array ) $usuario->roles;
		$rol_usuario = $roles_usuario[0];
	}

	// Si el rol del usuario es 'subscriber' o 'administrador' es que es profesional y enviamos el correo como tal
	if($rol_usuario=='subscriber' || $rol_usuario=='administrator')
	{
		$subject=str_replace('Nuevo pedido','Nuevo pedido PROFESIONAL',$subject);
	}
	// Si no es particular
	else
		$subject=str_replace('Nuevo pedido','Nuevo pedido PARTICULAR',$subject);

	// Devolvemos el subject
	return $subject;
}


function mytheme_add_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );

function parseTotal($total){
	$t=str_replace(',', '.', strip_tags(explode('<span class="woocommerce-Price-currencySymbol">', $total)[0]));
	$bi=number_format((float)round($t/1.21,2), 2, '.', '');
	$iva=number_format((float)round($t-$bi,2), 2, '.', '');
	$res['total']=str_replace('.',',',$t).'€';
	$res['bi']=str_replace('.',',',$bi).'€';
	$res['iva']=str_replace('.',',',$iva).'€';
	return $res;
}
function swwp_change_coupon_preview( $label, $coupon ) {

	// WC 3.0+ compatibility
	if ( is_callable( array( $coupon, 'get_description' ) ) ) {
		$description = $coupon->get_description();
	} else {
		$coupon_post = get_post( $coupon->id );
		$description = ! empty( $coupon_post->post_excerpt ) ? $coupon_post->post_excerpt : null;
	}

	return $description ? sprintf( esc_html__( 'Coupon: %s', 'woocommerce' ), $description ) : esc_html__( 'Coupon', 'woocommerce' );
}
add_filter( 'woocommerce_cart_totals_coupon_label', 'swwp_change_coupon_preview', 10, 2 );

if ( !function_exists('wp_new_user_notification_email') ) {
   function wp_new_user_notification_email( ) {}
}
remove_action( 'register_new_user', 'wp_new_user_notification_email' );

add_action('phpmailer_init', 'wse199274_intercept_registration_email');
function wse199274_intercept_registration_email($phpmailer){
    $admin_email = get_option( 'admin_email' );

    # Intercept username and password email by checking subject line
    if( strpos($phpmailer->Subject, 'Your username and password info') ){
        # clear the recipient list
        $phpmailer->ClearAllRecipients();
        # optionally, send the email to the WordPress admin email
        //$phpmailer->AddAddress($admin_email);
    }else{
        #not intercepted
    }
}
