<?php
/**
 * Upfate page content.
 *
 * @package C4WP
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="wrap features-wrap">
	<div class="c4wp-upgrade-section">
		
		<div class="content-block">
			<div class="logo-wrap">
				<img src="<?php echo esc_url( C4WP_PLUGIN_URL . 'assets/img/c4wp-logo-full.png' ); ?>" alt="">
			</div>
			<p><?php esc_html_e( 'Add spam protection to block spam bots and allow real humans to easily interact with your WordPress website by adding CAPTCHA to any form on your website, including comments forms, login forms, and checkout pages.', 'c4wp-wpp' ); ?></p>
			<p><?php esc_html_e( 'Get started within just minutes with CAPTCHA 4WP, an easy to use WordPress plugin that helps you protect your website from any type of spam and automated bot attacks.', 'c4wp-wpp' ); ?></p>
			<p><?php esc_html_e( 'Upgrade today for access to these plugin feature\'s and our first class premium support', 'c4wp-wpp' ); ?></p>
			<div class="premium-cta">
			<a href="https://www.wpwhitesecurity.com/wordpress-plugins/captcha-plugin-wordpress/pricing/?utm_source=plugin&utm_medium=referral&utm_campaign=C4WP&utm_content=features+page+upgrade" target="_blank" rel="noopener">Upgrade to Premium</a> <a class="text-link" href="https://www.wpwhitesecurity.com/wordpress-plugins/captcha-plugin-wordpress/plugin-trial/?utm_source=plugin&utm_medium=banner&utm_campaign=C4WP&utm_content=get+trial" target="_blank" rel="noopener">Get a FREE 7-day trial</a>
				
			</div>
		</div>

		<div class="content-block">
			<table class="c21 feature-table">
				<tbody>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10 c4"><span class="c5"></span></p>
						</td>
						<td class="c8 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5">Premium</span></p>
						</td>
						<td class="c12 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5">Free</span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Email support and forum access</strong>We stand behind all of our products with world-class support and a team of professionals who absolutely care.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Easy to set up and use</strong>Set up CAPTCHA in minutes and add it to virtually any form you want at the click of a button.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Choose from different types of tests</strong>With support for multiple CAPTCHA methods available straight out of the box, you can choose the one that best fits your requirements.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>WordPress login and comments spam protection</strong>Easily add CAPTCHA to your WordPress login page and comments section to protect your website from spam.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>WordPress registration and lost password/reset form protection</strong>Easily add CAPTCHA to protect your website from spam and fake users registration and lost password/reset pages from spam.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Use CAPTCHA in any country</strong>Select from different domains to prevent service outages due to domain restrictions.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Set CAPTCHA passmark score</strong>Fine-tune CAPTCHA tests in real-time by setting the passmark score to avoid false positives.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Configurable CAPTCHA language</strong>Choose from multiple CAPTCHA text languages.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Use the language that your website viewers understand</strong>Avoid confusion and configure the plugin to automatically change the CAPTCHA text language to match that of the visitor.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Spam protection for your WooCommerce stores</strong>Add CAPTCHA to WooCommerce forms such as the login page and checkout at the click of a mouse.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Specify where to put the CAPTCHA test on WooCommerce checkout page</strong>Personalize your customers' experience and meet your branding requirements.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>1-click Contact Form 7 spam protection</strong>Add CAPTCHA to any Contact Form 7 form at the click of a button. No shortcodes required.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>1-click spam protection for Mailchimp for WordPress forms</strong>Add CAPTCHA to any MC4WP form at the click of a button. No shortcodes required.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>CAPTCHA spam protection for BuddyPress, bbPress, & many other third-party plugins</strong>Out of the box support for many popular third-party plugins.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Add CAPTCHA to any type of form, even PHP forms</strong>Use the plugin's shortcode or code snippet to add CAPTCHA tests to any type of forms, even non-WordPress PHP forms.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>Strike a balance between security and usability</strong>Request CAPTCHA on failed logins only for an improved user experience that doesn't compromise security.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>White-list logged in users</strong>Logged in users can be trusted, so there is no need for CAPTCHA. You can also configure this by user role.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>White-list specific IP addresses</strong>White-list IPs to ensure automated process & integrations running to your website continue to operate smoothly.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>White-list specific URLs</strong>If you configure CAPTCHA to run invisibly on all pages, use this setting to exclude it from specific URLs.</span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr><tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong>No Ads!</strong></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<div class="premium-cta">
			<a href="https://www.wpwhitesecurity.com/wordpress-plugins/captcha-plugin-wordpress/pricing/?utm_source=plugin&utm_medium=referral&utm_campaign=C4WP&utm_content=features+page+upgrade" target="_blank" rel="noopener">Upgrade to Premium</a> <a class="text-link" href="https://www.wpwhitesecurity.com/wordpress-plugins/captcha-plugin-wordpress/plugin-trial/?utm_source=plugin&utm_medium=banner&utm_campaign=C4WP&utm_content=get+trial" target="_blank" rel="noopener">Get a FREE 7-day trial</a>
		</div>

	</div>
</div>

<style>
	#postbox-container-1 {
		display: none;
	}
	.features-wrap {
		background: #fff;
		padding: 25px 30px;
		max-width: 880px;
	}

	.features-wrap h2 {
		font-size: 28px;
			margin-bottom: 30px;
	}

	.features-wrap p {
		font-size: 14px;
		line-height: 28px;
		font-weight: normal;
	}

	.feature-list {
		margin-bottom: 20px;
	}

	.feature-list li {
		margin-bottom: 10px;
		font-size: 15px;
	}

	.feature-list li .dashicons {
		color: #50284E;
	}

	.premium-cta {
		margin: 25px 0 15px;
		text-align: center;
	}

	.premium-cta .text-link {
		color: #50284E;
		background: transparent;
		border: #50284E;
		text-decoration: dashed;
	}

	.premium-cta a, .table-link {
		background-color: #50284E;
		color: #fff;
		padding: 15px 26px;
		border-radius: 30px;
		font-size: 16px;
		white-space: nowrap;
		text-decoration: none;
		font-weight: 700;
		display: inline-block;
		margin-right: 15px;
		border: 2px solid #50284E;
	}

	.premium-cta a:hover, .table-link:hover, .premium-cta a.inverse, .table-link.inverse {
		color: #50284E;
		background-color: #fff;
	}

	.content-block {
		margin-bottom: 26px;
		border-bottom: 1px solid #eee;
		padding-bottom: 15px;
		overflow: hidden;
	}

	.feature-table strong {
		font-size: 16px;
		clear: both;
		display: block;
	}
	
	.feature-table tr td {
		text-align: center;
		min-width: 200px
	}
	.feature-table tr td:first-of-type {
		text-align: left;
		font-weight: 500;
	}
	.feature-table td p {
		margin-top: 0;
	}
	.row-head span {
		font-size: 17px;
		font-weight: 700;
	}
	.feature-table .dashicons {
		color: #50284E;
	}
	.feature-table .dashicons-no {
		color: red;
	}
	.table-link {
		font-size: 14px;
		padding: 9px;
		width: 193px;
		margin-top: 10px;
	}
	.pull-up {
		position: relative;
		top: -23px;
	}

	.logo-wrap img {
		max-width: 230px;
		margin-top: 20px;
	}

	.logo-wrap {
		float: left;
		margin-right: 30px;
	}

</style>
